/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 10);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./resources/js/parts/topic_posts.js":
/*!*******************************************!*\
  !*** ./resources/js/parts/topic_posts.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

(function () {
  "use strict";

  if (jQuery().summernote) {
    makeSummernote($('#summernote'), 280);
  }

  $('body').on('click', '.panel-file-manager', function (e) {
    e.preventDefault();
    $(this).filemanager('file', {
      prefix: '/laravel-filemanager'
    });
  });
  $('body').on('click', '.js-close-reply-post', function (e) {
    e.preventDefault();
    var $topicPostsReplyCard = $(this).closest('.topic-posts-reply-card');
    $topicPostsReplyCard.addClass('d-none');
    $topicPostsReplyCard.find('.js-reply-post-id').val('');
  });
  $('body').on('click', '.js-save-post', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar primary').prop('disabled', true);
    $form.find('.invalid-feedback').text('');
    $form.find('.is-invalid').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue">' + replyToTopicSuccessfullySubmittedLang + '</h3>',
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }

      $this.removeClass('loadingbar primary').prop('disabled', false);
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('click', '.js-reply-post-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var postId = $this.attr('data-id');
    var $card = $this.closest('.topics-post-card');
    var userName = $card.find('.js-post-user-name').text();
    var description = '';
    $card.find('.topic-post-description').contents().filter(function () {
      description += this.innerText;
    });
    var shortText = jQuery.trim(description).substring(0, 125).split(" ").slice(0, -1).join(" ") + "...";
    var $topicPostsReplyCard = $('.topic-posts-reply-card');
    $topicPostsReplyCard.removeClass('d-none');
    $topicPostsReplyCard.find('.js-reply-post-id').val(postId);
    $topicPostsReplyCard.find('.js-reply-post-title span').text(userName);
    $topicPostsReplyCard.find('.js-reply-post-description').text(shortText);
    $('html, body').animate({
      scrollTop: $topicPostsReplyCard.offset().top - 100
    }, 500);
  });
  /**
   * report modal
   * */

  $('body').on('click', '.js-topic-post-report', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemId = $this.attr('data-id');
    var type = $this.attr('data-type');
    var topicReportModal = $('#topicReportModal');
    topicReportModal.find('.js-item-id-input').val(itemId);
    topicReportModal.find('.js-item-type-input').val(type);
    var modal_html = topicReportModal.html();
    Swal.fire({
      html: modal_html,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '48rem'
    });
  });
  $('body').on('click', '.js-topic-report-submit', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar primary').prop('disabled', true);
    $form.find('.invalid-feedback').text('');
    $form.find('.is-invalid').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue">' + reportSuccessfullySubmittedLang + '</h3>',
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }

      $this.removeClass('loadingbar primary').prop('disabled', false);
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('click', '.js-topic-post-like', function (e) {
    e.preventDefault();
    var $this = $(this);
    var parent = $this.closest('.topic-post-like-btn');
    var likeCount = parent.find('.js-like-count').text();
    var action = $this.attr('data-action');
    var isLiked = $this.hasClass('liked');
    $this.toggleClass('liked');
    var newLikeCount = isLiked ? likeCount - 1 : Number(likeCount) + 1;
    parent.find('.js-like-count').text(newLikeCount);
    $.post(action, {}, function (result) {
      if (result && result.code === 200) {
        parent.find('.js-like-count').text(result.likes);

        if (result.status) {
          $this.addClass('liked');
        } else {
          $this.removeClass('liked');
        }
      }
    }).fail(function (err) {
      $this.toggleClass('liked');
      parent.find('.js-like-count').text(likeCount);
    });
  });
  $('body').on('click', '.js-btn-post-un-pin, .js-btn-post-pin', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    loadingSwl();
    $.post(action, {}, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + changesSavedSuccessfullyLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      } else {
        Swal.fire(oopsLang, somethingWentWrongLang, 'error');
      }
    }).fail(function (err) {
      Swal.fire(oopsLang, somethingWentWrongLang, 'error');
    });
  });
  $('body').on('click', '.js-topic-bookmark', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    $this.toggleClass('text-warning');
    var style = getComputedStyle(document.body);
    var primaryColor = style.getPropertyValue('--primary');
    var warningColor = style.getPropertyValue('--warning');
    $.post(action, {}, function (result) {
      if (result && result.code === 200) {
        if (topicBookmarkedSuccessfullyLang && topicUnBookmarkedSuccessfullyLang) {
          $.toast({
            text: result.add ? topicBookmarkedSuccessfullyLang : topicUnBookmarkedSuccessfullyLang,
            bgColor: result.add ? primaryColor : warningColor,
            textColor: 'white',
            hideAfter: 10000,
            position: 'bottom-right',
            icon: 'success'
          });
        }
      } else {
        Swal.fire(oopsLang, somethingWentWrongLang, 'error');
      }
    }).fail(function (err) {
      Swal.fire(oopsLang, somethingWentWrongLang, 'error');
    });
  });

  function makeEditPostHtml(post, action, record) {
    var _post$attach;

    return "<div>\n        <h3 class=\"section-title after-line font-20 text-dark-blue\">".concat(editPostLang, "</h3>\n\n        <form action=\"").concat(action, "\" method=\"post\" class=\"mt-25\">\n            <div class=\"form-group text-left\">\n                <label class=\"input-label\">").concat(descriptionLang, "</label>\n                <textarea id=\"summernote_").concat(record, "\" name=\"description\" class=\"form-control\">").concat(post.description, "</textarea>\n                <div class=\"invalid-feedback\"></div>\n            </div>\n\n            <div class=\"row\">\n                <div class=\"col-12 col-md-7\">\n                    <div class=\"form-group text-left\">\n                        <label class=\"input-label\">").concat(editAttachmentLabelLang, "</label>\n\n                        <div class=\"d-flex align-items-center\">\n                            <div class=\"input-group mr-10\">\n                                <div class=\"input-group-prepend\">\n                                    <button type=\"button\" class=\"input-group-text panel-file-manager\" data-input=\"postAttachmentInput_").concat(record, "\" data-preview=\"holder\">\n                                        ").concat(typeof feather !== "undefined" ? "<i data-feather=\"upload\" width=\"18\" height=\"18\" class=\"text-white\"></i>" : "<i class=\"fa fa-upload\"></i>", "\n                                    </button>\n                                </div>\n                                <input type=\"text\" name=\"attach\" id=\"postAttachmentInput_").concat(record, "\" value=\"").concat((_post$attach = post.attach) !== null && _post$attach !== void 0 ? _post$attach : '', "\" class=\"form-control\"/>\n                            </div>\n\n                            <button type=\"button\" class=\"js-save-post btn btn-primary btn-sm\">").concat(sendLang, "</button>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </form>\n    </div>");
  }

  $('body').on('click', '.js-post-edit', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    loadingSwl();
    $.get(action, function (result) {
      if (result && result.code === 200) {
        var post = result.post;
        var random = randomString();
        var html = makeEditPostHtml(post, action, random);
        Swal.fire({
          html: html,
          showConfirmButton: false,
          width: '60rem',
          onOpen: function onOpen() {
            if (jQuery().summernote) {
              makeSummernote($('#summernote_' + random), 280);
            }

            if (typeof feather !== "undefined") {
              feather.replace();
            }
          }
        });
      } else {
        Swal.fire(oopsLang, somethingWentWrongLang, 'error');
      }
    }).fail(function (err) {
      Swal.fire(oopsLang, somethingWentWrongLang, 'error');
    });
  });
  $('body').on('click', '.login-to-access', function (e) {
    e.preventDefault();

    if (notLoginToastTitleLang && notLoginToastMsgLang) {
      $.toast({
        heading: notLoginToastTitleLang,
        text: notLoginToastMsgLang,
        bgColor: '#f63c3c',
        textColor: 'white',
        hideAfter: 10000,
        position: 'bottom-right',
        icon: 'error'
      });
    }
  });
})(jQuery);

/***/ }),

/***/ 10:
/*!*************************************************!*\
  !*** multi ./resources/js/parts/topic_posts.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /home/mostafa/projects/webinar/resources/js/parts/topic_posts.js */"./resources/js/parts/topic_posts.js");


/***/ })

/******/ });