
 ## Laravel Paytr

This package has been developed only for the Paytr Iframe API service.

**How to install?**

    composer require gizemsever/laravel-paytr
    
Publish provider
   
    php artisan vendor:publish --provider="Gizemsever\LaravelPaytr\PaytrServiceProvider"

Setup your environment

    PAYTR_MERCHANT_ID=''  
    PAYTR_MERCHANT_SALT=''  
    PAYTR_MERCHANT_KEY=''  
    PAYTR_SUCCESS_URL='https://your-domain/success-payment'  
    PAYTR_FAIL_URL='https://your-domain/fail-payment'  
    PAYTR_TEST_MODE=true

*NOTE: PAYTR_SUCCESS_URL and PAYTR_FAIL_URL are the frontend URLs that will be redirected after the payment screen. They are not addresses where payment will be verified.*

 **Create your product basket**
	
	<?php 
	
	$products = [
		[
			'Product Name',
			14.5, // Product Price
			5 // Quantity
		]
	];
    $basket = \Paytr::basket()->addProducts($products);


 **Create Payment Request**

    <?php 
	    use Gizemsever\LaravelPaytr\Payment\Currency;
	    
		$payment = \Paytr::payment()  
		    ->setCurrency(Currency::TRY)  
		    ->setUserPhone($phone)  
		    ->setUserAddress($address)  
		    ->setNoInstallment(1)  
		    ->setMaxInstallment(1)  
		    ->setEmail($email)  
		    ->setMerchantOid($oid) // Payment id generated by you 
		    ->setUserIp($ipAddress)  
		    ->setPaymentAmount($paymentAmount)  // Total payment amount
		    ->setUserName($name)  
		    ->setBasket($basket);  

		$paymentRequest = \Paytr::createPayment($payment);
		if($paymentRequest->isSuccess()) {
			$token = $paymentRequest->getToken();
			// If the payment request has been successfully created, 
			// you can view the iframe using the token.
			// Iframe URL: 'https://www.paytr.com/odeme/guvenli/'. $token
		}
			
**Verify Payment**

	You must set the Callback Url, where the result of the payment transaction will be notified to you, on the Paytr Panel. 

You should add this endpoint as route

    Route::post('paytr/payment-check', [PaytrController::class, 'checkPayment']);

And check payment

	<?php 
	use Illuminate\Http\Request;
	use App\Http\Controllers\Controller;
	
    class PaytrController extends Controller  
	{  
	    public function checkPayment(Request $request)  
	    {
		    $verification = \Paytr::paymentVerification($request);  
			if (!$verification->verifyRequest()) {  
			    // Throw unauthorized  
			}
			
			$oid = $verification->getMerchantOid(); // Payment id generated by you 
			$isSuccess = $verification->isSuccess(); // Is the payment status successful?
			// ... 
		}
	}