@php

$theme1_service_type = serviceTypeTab();
$theme1_destinations = destinations();

@endphp


@if ($theme1_service_type->count() > 0)
<!-- Modern Booking Form Area Start -->
<style>
    /* Modern Booking Form Styles - Matching Reference Design */
    .modern-booking-wrapper {
        padding: 20px 0 0px 0;
        position: relative;
        z-index: 10;
        top: -88px;
    }

    .modern-booking-container {
        max-width: 950px;
        margin: 0 auto;
        padding: 0 15px;
    }

    /* Service Type Tabs */
    .modern-service-tabs {
        display: flex;
        justify-content: center;
        gap: 8px;
        margin-bottom: 20px;
        flex-wrap: wrap;
    }

    .modern-service-tab {
        background: rgba(255, 255, 255, 0.15);
        border: 1px solid rgba(255, 255, 255, 0.3);
        color: #fff;
        padding: 10px 20px;
        border-radius: 25px;
        font-size: 14px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .modern-service-tab:hover,
    .modern-service-tab.active {
        background: rgba(255, 255, 255, 0.95);
        color: #333;
        border-color: #fff;
    }

    .modern-service-tab .icon img {
        width: 18px;
        height: auto;
        filter: brightness(0) invert(1);
        transition: filter 0.3s ease;
    }

    .modern-service-tab:hover .icon img,
    .modern-service-tab.active .icon img {
        filter: none;
    }

    .modern-service-tab .icon i {
        font-size: 16px;
    }

    /* Main Search Bar */
    .modern-search-bar {
        background: #fff;
        border-top-left-radius: 24px;
        border-top-right-radius: 24px;
        box-shadow: 0 8px 40px rgba(0, 0, 0, 0.15);
        display: flex;
        align-items: center;
        padding: 11px 8px 8px 25px;
        position: relative;
    }

    .modern-search-fields {
        display: flex;
        align-items: center;
        flex: 1;
        gap: 0;
    }

    /* Destination Field */
    .modern-field-destination {
        flex: 1;
        min-width: 200px;
        position: relative;
    }

    .modern-field-label {
        font-size: 11px;
        color: #666;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 2px;
        display: block;
    }
.modern-field-label i{padding-right:5px; font-size:20px;color:#999999;}

    .modern-field-destination .field-content {
        display: flex;
        align-items: center;
        gap: 12px;
        cursor: pointer;
        padding: 8px 0;
    }

    .modern-field-destination .sun-icon {
        width: 28px;
        height: 28px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .modern-field-destination .sun-icon svg {
        width: 26px;
        height: 26px;
    }

    .modern-field-destination .field-text {
        font-size: 15px;
        color: #888;
        font-weight: 400;
    }

    .modern-field-destination .field-value {
        font-size: 15px;
        color: #333;
        font-weight: 500;
    }

    /* Destination Dropdown */
    .modern-destination-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
        padding: 15px 0;
        z-index: 1000;
        display: none;
        margin-top: 10px;
        max-height: 280px;
        overflow-y: auto;
    }

    .modern-destination-dropdown.show {
        display: block;
    }

    .modern-destination-dropdown ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .modern-destination-dropdown li {
        padding: 12px 20px;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 12px;
        transition: background 0.2s ease;
        font-size: 14px;
        color: #333;
    }

    .modern-destination-dropdown li:hover {
        background: #f5f5f5;
    }

    .modern-destination-dropdown li i {
        color: #e76f51;
        font-size: 14px;
    }

    /* Divider */
    .modern-field-divider {
        width: 1px;
        height: 45px;
        background: #e0e0e0;
        margin: 0 20px;
    }

    /* Date Fields */
    .modern-field-dates {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .modern-field-date {
        text-align: center;
        min-width: 80px;
        position: relative;
    }

    .modern-field-date .date-icon {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .modern-field-date .calendar-icon {
        width: 20px;
        height: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .modern-field-date .calendar-icon svg {
        width: 18px;
        height: 18px;
    }

    .modern-field-date .date-value {
        font-size: 18px;
        color: #333;
        font-weight: 600;
        cursor: pointer;
    }

    .modern-field-date .date-value input {
        border: none;
        outline: none;
        background: transparent;
        font-size: 18px;
        color: #333;
        font-weight: 600;
        text-align: center;
        width: 100%;
        cursor: pointer;
    }

    .modern-field-date .date-value input::placeholder {
        color: #999;
    }

    .modern-date-arrow {
        color: #aaa;
        font-size: 16px;
        display: flex;
        align-items: center;
    }

    .modern-date-arrow svg {
        width: 16px;
        height: 16px;
    }

    /* Guest Field */
    .modern-field-guests {
        min-width: 100px;
        position: relative;
    }

    .modern-field-guests .field-content {
        display: flex;
        align-items: center;
        gap: 10px;
        cursor: pointer;
        padding: 8px 0;
    }

    .modern-field-guests .guest-icon {
        width: 22px;
        height: 22px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .modern-field-guests .field-text {
        font-size: 15px;
        color: #888;
    }

    .modern-field-guests .field-value {
        font-size: 15px;
        color: #333;
        font-weight: 500;
    }

    /* Guest Dropdown */
    .modern-guests-dropdown {
        position: absolute;
        top: 100%;
        right: 0;
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
        padding: 20px;
        z-index: 1000;
        display: none;
        margin-top: 10px;
        min-width: 250px;
    }

    .modern-guests-dropdown.show {
        display: block;
    }

    .modern-guests-dropdown ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .modern-guests-dropdown li {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 12px 0;
        border-bottom: 1px solid #f0f0f0;
    }

    .modern-guests-dropdown li:last-child {
        border-bottom: none;
    }

    .modern-guests-dropdown .guest-label {
        font-size: 14px;
        color: #333;
        font-weight: 500;
    }

    .modern-quantity-controls {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .modern-quantity-controls .qty-btn {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        border: 1px solid #ddd;
        background: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .modern-quantity-controls .qty-btn:hover {
        border-color: #e76f51;
        color: #e76f51;
    }

    .modern-quantity-controls .qty-value {
        width: 30px;
        text-align: center;
        font-size: 16px;
        font-weight: 500;
        color: #333;
    }

    .modern-quantity-controls .qty-value input {
        border: none;
        outline: none;
        background: transparent;
        width: 100%;
        text-align: center;
        font-size: 16px;
        font-weight: 500;
        color: #333;
    }

    /* Search Button */
    .modern-search-btn {
        background: #e76f51;
        color: #fff;
        border: none;
        border-radius: 50px;
        padding: 18px 35px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 8px;
        margin-left: 15px;
    }

    .modern-search-btn:hover {
        background: #d35f42;
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(231, 111, 81, 0.4);
    }

    /* Promo Banner */
    .modern-promo-banner {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        border-radius: 0 0 20px 20px;
        padding: 14px 25px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        margin-top: -10px;
        position: relative;
        z-index: 5;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    }

    .modern-promo-banner .promo-icon {
        font-size: 18px;
    }

    .modern-promo-banner .promo-text {
        font-size: 14px;
        color: #78350f;
        font-weight: 500;
    }

    /* Tab Content */
    .modern-tab-content {
        display: none;
    }

    .modern-tab-content.active {
        display: block;
    }

    /* Responsive Design */
    @media (max-width: 992px) {
        .modern-search-bar {
            flex-direction: column;
            border-radius: 24px;
            padding: 20px;
            gap: 15px;
        }

        .modern-search-fields {
            flex-direction: column;
            width: 100%;
            gap: 15px;
        }

        .modern-field-destination,
        .modern-field-guests {
            width: 100%;
        }

        .modern-field-divider {
            display: none;
        }

        .modern-field-dates {
            width: 100%;
            justify-content: center;
            padding: 10px 0;
            border-top: 1px solid #eee;
            border-bottom: 1px solid #eee;
        }

        .modern-search-btn {
            width: 100%;
            justify-content: center;
            margin-left: 0;
        }

        .modern-destination-dropdown,
        .modern-guests-dropdown {
            left: 0;
            right: 0;
        }
    }

    @media (max-width: 576px) {
        .modern-service-tabs {
            gap: 5px;
        }

        .modern-service-tab {
            padding: 8px 14px;
            font-size: 12px;
        }

        .modern-promo-banner {
            padding: 12px 15px;
            flex-direction: column;
            text-align: center;
            gap: 5px;
        }

        .modern-promo-banner .promo-text {
            font-size: 12px;
        }
    }
</style>

<div class="modern-booking-wrapper">
    <div class="modern-booking-container">
        <!-- Service Type Tabs -->
        <div class="modern-service-tabs d-none" id="modern-nav-tab" role="tablist">
            @foreach ($theme1_service_type as $key => $service_type)
            <button class="modern-service-tab {{ $loop->first ? 'active' : '' }}"
                id="modern-service_type-{{ $service_type->id }}-tab" data-bs-toggle="tab"
                data-bs-target="#modern-service_type-{{ $service_type->id }}" type="button" role="tab"
                aria-controls="modern-service_type-{{ $service_type->id }}"
                aria-selected="{{ $loop->first ? 'true' : 'false' }}">
                <span class="icon">
                    @if ($service_type->image)
                    <img width="18" height="12" src="{{ asset($service_type->image) }}">
                    @elseif ($service_type->icon)
                    <i class="{{ $service_type->icon }}"></i>
                    @endif
                </span>
                <span>{{ $service_type->name }}</span>
            </button>
            @endforeach
        </div>

        <!-- Tab Contents -->
        <div class="tab-content" id="modern-nav-tabContent">
            @foreach ($theme1_service_type as $key => $service_type)
            <div class="modern-tab-content {{ $loop->first ? 'active' : '' }}"
                id="modern-service_type-{{ $service_type->id }}" role="tabpanel"
                aria-labelledby="modern-service_type-{{ $service_type->id }}-tab" tabindex="0">

                <form x-data="bookingForm()" @submit.prevent="submitForm">
                    <!-- Main Search Bar -->
                    <div class="modern-search-bar">
                        <div class="modern-search-fields">
                            <!-- Destination Field -->
                            <div class="modern-field-destination" x-data="{ open: false }" @click.away="open = false">
                                
                                <span class="modern-field-label"><i class="fa-solid fa-location-dot"></i>{{ __('Where to?') }}</span>
                                <div class="field-content" @click="open = !open">
                                    <div class="sun-icon">
                                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <circle cx="12" cy="12" r="5" fill="#f59e0b" />
                                            <path
                                                d="M12 2v2M12 20v2M2 12h2M20 12h2M4.93 4.93l1.41 1.41M17.66 17.66l1.41 1.41M4.93 19.07l1.41-1.41M17.66 6.34l1.41-1.41"
                                                stroke="#f59e0b" stroke-width="2" stroke-linecap="round" />
                                        </svg>
                                    </div>
                                    <span x-show="!destination" class="field-text">
                                        {{ __('Search Destination, Stay, or Trip') }}
                                    </span>
                                    <span x-show="destination" x-text="destination" class="field-value"></span>
                                </div>

                                <!-- Destination Dropdown -->
                                <div class="modern-destination-dropdown" :class="{ 'show': open }">
                                    <ul>
                                        @foreach ($theme1_destinations as $key => $dest)
                                        <li
                                            @click="selectDestination(`{{ $dest->id }}`, `{{ $dest->name }}`); open = false">
                                            <i class="fa-regular fa-location-dot"></i>
                                            <span>{{ $dest->name }}</span>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>

                            <div class="modern-field-divider"></div>

                            <!-- Date Fields -->
                            <div class="modern-field-dates">
                                <!-- Check-in -->
                                <div class="modern-field-date">
                                    <span class="modern-field-label"><i class="fa-solid fa-pen-to-square"></i>
                                    {{ __('Check-in') }}</span>
                                    <div class="date-icon">
                                        <div class="calendar-icon">
                                            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="3" y="4" width="18" height="18" rx="2" stroke="#6b7280"
                                                    stroke-width="2" />
                                                <path d="M3 10h18" stroke="#6b7280" stroke-width="2" />
                                                <path d="M8 2v4M16 2v4" stroke="#6b7280" stroke-width="2"
                                                    stroke-linecap="round" />
                                                <rect x="7" y="14" width="4" height="4" rx="1" fill="#e76f51" />
                                            </svg>
                                        </div>
                                        <div class="date-value">
                                            <input x-model="check_in" class="modern-datepicker" type="text"
                                                placeholder="31 Dec" readonly>
                                        </div>
                                    </div>
                                </div>

                                <!-- Arrow -->
                                <div class="modern-date-arrow">
                                    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5 12h14M13 6l6 6-6 6" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>

                                <!-- Check-out -->
                                <div class="modern-field-date">
                                    <span class="modern-field-label"><i class="fa-solid fa-suitcase"></i>{{ __('Check-out') }}</span>
                                    <div class="date-icon">
                                        <div class="date-value">
                                            <input x-model="check_out" class="modern-datepicker" type="text"
                                                placeholder="01 Jan" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="modern-field-divider"></div>

                            <!-- Guests Field -->
                            <div class="modern-field-guests" x-data="{ open: false }" @click.away="open = false">
                                <span class="modern-field-label"><i class="fa-solid fa-user"></i>{{ __('Guests') }}</span>
                                <div class="field-content" @click="open = !open">
                                    <div class="guest-icon">
                                        <svg width="18" height="18" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M1.51285 15.2889C1.33507 15.2889 1.15729 15.2 1.0684 15.1111C0.979514 14.9334 0.890625 14.8445 0.890625 14.6667C0.890625 13.4222 1.24618 12.1778 1.8684 11.0222C2.49063 9.95558 3.4684 8.9778 4.53507 8.35558C4.09062 7.82225 3.73507 7.11114 3.55729 6.40003C3.4684 5.68892 3.4684 4.88892 3.64618 4.26669C3.82396 3.55558 4.2684 2.84447 4.71285 2.31114C5.24618 1.7778 5.8684 1.33336 6.49063 1.15558C7.02396 0.977805 7.55729 0.888916 8.09063 0.888916C8.2684 0.888916 8.53507 0.888916 8.71285 0.888916C9.42396 0.977805 10.1351 1.24447 10.7573 1.68892C11.3795 2.13336 11.824 2.66669 12.1795 3.28892C12.5351 3.91114 12.7128 4.62225 12.7128 5.42225C12.7128 6.48892 12.3573 7.55558 11.6462 8.35558C12.1795 8.71114 12.7128 9.06669 13.2462 9.51114C13.9573 10.2222 14.4017 10.9334 14.8462 11.8222C15.2017 12.7111 15.3795 13.6 15.3795 14.5778C15.3795 14.7556 15.2906 14.9334 15.2017 15.0222C15.1128 15.1111 14.9351 15.2 14.7573 15.2C14.6684 15.2 14.5795 15.2 14.4906 15.1111C14.4017 15.1111 14.3128 15.0222 14.3128 14.9334C14.224 14.8445 14.224 14.8445 14.1351 14.7556C14.1351 14.6667 14.0462 14.5778 14.0462 14.4889C14.0462 13.6889 13.8684 12.9778 13.6017 12.2667C13.3351 11.5556 12.8906 10.9334 12.2684 10.4C11.7351 9.95558 11.2017 9.51114 10.5795 9.24447C9.8684 9.68892 9.0684 9.95558 8.09063 9.95558C7.20174 9.95558 6.31285 9.68892 5.60174 9.24447C4.62396 9.68892 3.73507 10.4 3.11285 11.3778C2.49063 12.3556 2.13507 13.4222 2.13507 14.5778C2.13507 14.7556 2.04618 14.9334 1.95729 15.0222C1.8684 15.2 1.69062 15.2889 1.51285 15.2889ZM8.09063 2.22225C7.4684 2.22225 6.84618 2.40003 6.31285 2.75558C5.69062 3.11114 5.33507 3.64447 5.0684 4.1778C4.80174 4.80003 4.71285 5.42225 4.89063 6.13336C4.97951 6.75558 5.33507 7.37781 5.77951 7.82225C6.22396 8.26669 6.84618 8.62225 7.4684 8.71114C7.64618 8.71114 7.91285 8.80003 8.09063 8.80003C8.53507 8.80003 8.97951 8.71114 9.33507 8.53336C9.95729 8.26669 10.4017 7.91114 10.8462 7.28892C11.2017 6.75558 11.3795 6.13336 11.3795 5.51114C11.3795 4.62225 11.024 3.82225 10.4017 3.20003C9.77951 2.48892 8.97951 2.22225 8.09063 2.22225Z"
                                                fill="#6b7280" />
                                        </svg>
                                    </div>
                                    <!-- Show placeholder when no values -->
                                    <span x-show="!rooms && !adults && !children" class="field-text">
                                        {{ __('Add Guests') }}
                                    </span>
                                    <!-- Show values when selected -->
                                    <span x-show="rooms || adults || children" class="field-value">
                                        <template x-if="rooms"><span x-text="rooms + ' Room'"></span></template>
                                        <template x-if="adults"><span
                                                x-text="', ' + adults + ' Adult'"></span></template>
                                        <template x-if="children"><span
                                                x-text="', ' + children + ' Child'"></span></template>
                                    </span>
                                </div>

                                <!-- Guests Dropdown -->
                                <div class="modern-guests-dropdown" :class="{ 'show': open }">
                                    <ul>
                                        <li>
                                            <span class="guest-label">{{ __('Rooms') }}</span>
                                            <div class="modern-quantity-controls">
                                                <span @click="decrementRooms" class="qty-btn">
                                                    <svg width="12" height="2" viewBox="0 0 14 2" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1H13" stroke="currentColor" stroke-width="1.5"
                                                            stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                                <div class="qty-value">
                                                    <input x-bind:value="rooms || 0" type="text" readonly>
                                                </div>
                                                <span @click="incrementRooms" class="qty-btn">
                                                    <svg width="12" height="12" viewBox="0 0 15 14" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1.21924 7H13.3836" stroke="currentColor"
                                                            stroke-width="1.5" stroke-linecap="round"
                                                            stroke-linejoin="round" />
                                                        <path d="M7.30176 13V1" stroke="currentColor" stroke-width="1.5"
                                                            stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </div>
                                        </li>
                                        <li>
                                            <span class="guest-label">{{ __('Adults') }}</span>
                                            <div class="modern-quantity-controls">
                                                <span @click="decrementAdults" class="qty-btn">
                                                    <svg width="12" height="2" viewBox="0 0 14 2" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1H13" stroke="currentColor" stroke-width="1.5"
                                                            stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                                <div class="qty-value">
                                                    <input x-bind:value="adults || 0" type="text" readonly>
                                                </div>
                                                <span @click="incrementAdults" class="qty-btn">
                                                    <svg width="12" height="12" viewBox="0 0 15 14" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1.21924 7H13.3836" stroke="currentColor"
                                                            stroke-width="1.5" stroke-linecap="round"
                                                            stroke-linejoin="round" />
                                                        <path d="M7.30176 13V1" stroke="currentColor" stroke-width="1.5"
                                                            stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </div>
                                        </li>
                                        <li>
                                            <span class="guest-label">{{ __('Children') }}</span>
                                            <div class="modern-quantity-controls">
                                                <span @click="decrementChildren" class="qty-btn">
                                                    <svg width="12" height="2" viewBox="0 0 14 2" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1 1H13" stroke="currentColor" stroke-width="1.5"
                                                            stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                                <div class="qty-value">
                                                    <input x-bind:value="children || 0" type="text" readonly>
                                                </div>
                                                <span @click="incrementChildren" class="qty-btn">
                                                    <svg width="12" height="12" viewBox="0 0 15 14" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M1.21924 7H13.3836" stroke="currentColor"
                                                            stroke-width="1.5" stroke-linecap="round"
                                                            stroke-linejoin="round" />
                                                        <path d="M7.30176 13V1" stroke="currentColor" stroke-width="1.5"
                                                            stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>
                                                </span>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Search Button -->
                        <button class="modern-search-btn" type="submit">
                            {{ __('Search') }}
                        </button>
                    </div>

                    <!-- Promo Banner -->
                    <div class="modern-promo-banner">
                        <span class="promo-icon">☀️</span>
                        <span class="promo-text">{{ __('Book directly and get best prices + enjoy early
                            check-in, late check-out & exclusive deals*') }}</span>
                    </div>
                </form>
            </div>
            @endforeach
        </div>
    </div>
</div>
<!-- Modern Booking Form Area End -->

@push('js_section')
<script>
    (function ($) {
        "use strict"
        $(document).ready(function () {
            // Initialize modern datepicker with date format
            $(".modern-datepicker").flatpickr({
                dateFormat: "d M",
                minDate: "today",
                disableMobile: true
            });

            // Tab switching functionality
            $('.modern-service-tab').on('click', function () {
                var targetId = $(this).attr('data-bs-target');

                // Update tab active state
                $('.modern-service-tab').removeClass('active');
                $(this).addClass('active');

                // Update content active state
                $('.modern-tab-content').removeClass('active');
                $(targetId).addClass('active');
            });
        });
    })(jQuery);
</script>

<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

<script>
    function bookingForm() {
        return {
            destination: '',
            destination_id: '',
            check_in: '',
            check_out: '',
            rooms: '',
            adults: '',
            children: '',

            selectDestination(destinationId, destinationName) {
                this.destination_id = destinationId;
                this.destination = destinationName;
            },

            incrementRooms() {
                this.rooms = (parseInt(this.rooms) || 0) + 1;
            },
            decrementRooms() {
                if (parseInt(this.rooms) > 0) {
                    this.rooms = parseInt(this.rooms) - 1;
                }
            },
            incrementAdults() {
                this.adults = (parseInt(this.adults) || 0) + 1;
            },
            decrementAdults() {
                if (parseInt(this.adults) > 0) {
                    this.adults = parseInt(this.adults) - 1;
                }
            },
            incrementChildren() {
                this.children = (parseInt(this.children) || 0) + 1;
            },
            decrementChildren() {
                if (parseInt(this.children) > 0) {
                    this.children = parseInt(this.children) - 1;
                }
            },

            submitForm() {
                const params = new URLSearchParams({
                    destination: this.destination,
                    destination_id: this.destination_id,
                    check_in: this.check_in,
                    check_out: this.check_out,
                    rooms: this.rooms,
                    adults: this.adults,
                    children: this.children
                });

                window.location.href = `{{ route('front.tourbooking.services') }}?` + params.toString();
            }
        }
    }
</script>
@endpush

@endif