@php
    $theme1_destination = getContent('theme1_destination.content', true);
    $destination_items = popularDestinations();
@endphp

<!-- tg-location-area-start -->
<div class="tg-location-area p-relative pb-60 pt-0">
 
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="tg-location-section-title text-center mb-50">
                    <h5 class="tg-section-subtitle mb-20 wow fadeInUp" data-wow-delay=".4s" data-wow-duration=".9s">
                        {{ getTranslatedValue($theme1_destination, 'sub_title') }}
                    </h5>
                    <h2 class="mb-20 text-capitalize wow fadeInUp" data-wow-delay=".5s" data-wow-duration=".9s">
                        {!! strip_tags(clean(getTranslatedValue($theme1_destination, 'title')), '<br>') !!}
                    </h2>
                    <p class="text-capitalize wow fadeInUp" data-wow-delay=".6s" data-wow-duration=".9s">
                        {!! strip_tags(clean(getTranslatedValue($theme1_destination, 'description')), '<br>') !!}
                    </p>
                </div>
            </div>
            @if ($destination_items->count() > 0)
                @foreach ($destination_items as $destination_item)
                    <div class="col-lg-3 col-md-6 col-sm-6 mb-40 wow fadeInUp" data-wow-delay=".3s" data-wow-duration=".9s">
                        <div class="destination-card">
                            <a href="{{ route('front.tourbooking.services', ['destination_id' => $destination_item->id, 'destination' => $destination_item->name]) }}" 
                               class="destination-card-link">
                                <div class="destination-image-wrapper">
                                    <img class="destination-image"
                                        src="{{ asset($destination_item->image) }}"
                                        alt="{{ $destination_item->country }}">
                                </div>
                                <div class="destination-content">
                                    <h3 class="destination-title">
                                        {{ $destination_item->country }}
                                    </h3>
                                </div>
                            </a>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
</div>
<!-- tg-location-area-end -->

@push('style_section')
    <style>
        /* Destination Card Styles */
        .destination-card {
            position: relative;
            transition: all 0.3s ease;
            background: transparent;
        }

        .destination-card:hover {
            transform: translateY(-5px);
        }

        .destination-card-link {
            display: block;
            text-decoration: none;
        }

        .destination-image-wrapper {
            position: relative;
            width: 100%;
            height: 271px;
            overflow: hidden;
            border-radius: 25px;
            margin-bottom: 15px;
        }

        .destination-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .destination-card:hover .destination-image {
            transform: scale(1.05);
        }

        .destination-content {
            padding: 0;
            text-align: center;
        }

        .destination-title {
            font-size: 21px;
            font-weight: 700;
            color: #1a1a1a;
            margin: 0;
            line-height: 1.3;
            transition: color 0.3s ease;
        }

        .destination-card:hover .destination-title {
            color: #0066b0;
        }

        /* Section Title Enhancements */
        .tg-location-section-title h2 {
            font-size: 34px;
            font-weight: 800;
            color: #1a1a1a;
            letter-spacing: -0.5px;
            text-align:left;
        }

        .tg-location-section-title h5 {
            font-size: 16px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 2px;
            color: #0066b0;
        }

        .tg-location-section-title p {
            font-size: 15px;
            color: #000;
            max-width: 700px;
            line-height: 1.7;
            text-align:left;
        }

        /* Responsive Adjustments */
        @media (max-width: 991px) {
            .destination-image-wrapper {
                height: 280px;
                border-radius: 22px;
            }

            .destination-title {
                font-size: 24px;
            }

            .tg-location-section-title h2 {
                font-size: 34px;
            }
        }

        @media (max-width: 767px) {
            .destination-image-wrapper {
                height: 260px;
                border-radius: 20px;
            }

            .destination-title {
                font-size: 22px;
            }

            .tg-location-section-title h2 {
                font-size: 30px;
            }
        }

        @media (max-width: 575px) {
            .destination-image-wrapper {
                height: 240px;
                border-radius: 18px;
            }

            .destination-title {
                font-size: 20px;
            }

            .tg-location-section-title h2 {
                font-size: 26px;
            }

            .col-sm-6.mb-40 {
                margin-bottom: 30px;
            }
        }
    </style>
@endpush