<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\TourBooking\App\Models\Destination;
use App\Http\Resources\DestinationResource;

class DestinationController extends Controller
{
    public function index()
    {
        $destinations = Destination::active()->ordered()->get();
        return DestinationResource::collection($destinations);
    }

    public function trending()
    {
        $destinations = Destination::active()->featured()->orderBy('ordering')->take(8)->get();
        return response()->json([
            'success' => true,
            'data' => DestinationResource::collection($destinations)
        ]);
    }

    public function show($id)
    {
        // Support searching by ID or Slug
        $prop = is_numeric($id) ? 'id' : 'slug';
        $destination = Destination::where($prop, $id)->active()->firstOrFail();

        return new DestinationResource($destination);
    }
}