use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\TourBooking\App\Models\Destination;
use Modules\TourBooking\App\Models\Service;
use App\Http\Resources\DestinationResource;
use App\Http\Resources\ServiceResource;

class PublicController extends Controller
{
public function home()
{
$featuredDestinations = Destination::active()->featured()->orderBy('ordering')->take(6)->get();
$featuredTours = Service::active()->featured()->take(6)->get();
$popularTours = Service::active()->popular()->take(6)->get();

// Fetch Hero Slider Data
$heroData = app('theme')->getContent('theme1_slider');
$heroValues = $heroData ? $heroData->data_values : null;

return response()->json([
'featuredDestinations' => DestinationResource::collection($featuredDestinations),
'featuredTours' => ServiceResource::collection($featuredTours),
'popularTours' => ServiceResource::collection($popularTours),
'hero' => $heroValues,
]);
}
public function header_menu()
{
$menu = \App\Models\Menu::where('location', 'header')->with(['items' => function($q) {
$q->where('parent_id', 0)->where('status', 1)->orderBy('order')->with(['children' => function($q2) {
$q2->where('status', 1)->orderBy('order');
}]);
}])->first();

// Fallback to primary_menu
if (!$menu) {
$menu = \App\Models\Menu::where('location', 'primary_menu')->with(['items' => function($q) {
$q->where('parent_id', 0)->where('status', 1)->orderBy('order')->with(['children' => function($q2) {
$q2->where('status', 1)->orderBy('order');
}]);
}])->first();
}

// Fallback to the first menu available
if (!$menu) {
$menu = \App\Models\Menu::with(['items' => function($q) {
$q->where('parent_id', 0)->where('status', 1)->orderBy('order')->with(['children' => function($q2) {
$q2->where('status', 1)->orderBy('order');
}]);
}])->first();
}

return response()->json([
'menu' => $menu ? $menu->items : []
]);
}
}