use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\TourBooking\App\Models\Service;
use App\Http\Resources\ServiceResource;

class ServiceController extends Controller
{
public function index(Request $request)
{
$query = Service::active();

if ($request->has('destination_id')) {
$query->where('destination_id', $request->destination_id);
}

if ($request->has('type')) {
// Assuming type is handled via relation or field, but keeping it simple for now
// You might need to check ServiceType model
}

if ($request->has('featured')) {
$query->featured();
}

$services = $query->paginate(12);
return ServiceResource::collection($services);
}

public function show($id)
{
$prop = is_numeric($id) ? 'id' : 'slug';
$service = Service::where($prop, $id)->active()->firstOrFail();
return new ServiceResource($service);
}
}