<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DestinationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => (string) $this->id,
            'name' => $this->translation->name ?? $this->name,
            'slug' => $this->slug,
            'country' => $this->country,
            'image' => $this->image ? asset($this->image) : null,
            'description' => $this->translation->description ?? $this->description,
            'rating' => (float) $this->rating,
            'totalReviews' => (int) $this->total_reviews,
            'price_from' => (float) $this->price,
        ];
    }
}
