<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => (string) $this->id,
            'title' => $this->translation->title ?? $this->title,
            'destinationId' => (string) $this->destination_id,
            'destination' => $this->destination->translation->name ?? $this->destination->name ?? '',
            'image' => $this->thumbnail->image ? asset($this->thumbnail->image) : null,
            'price' => (float) $this->discount_price ?: (float) $this->price_per_person,
            'originalPrice' => (float) $this->full_price,
            'currency' => session('currency_code', 'USD'), // Simplified
            'duration' => $this->duration,
            'rating' => (float) $this->rating,
            'totalReviews' => (int) $this->total_reviews,
            'description' => $this->translation->description ?? $this->description,
            'highlights' => $this->highlights,
            'included' => $this->included,
            'excluded' => $this->excluded,
            // For Hotels
            'name' => $this->translation->title ?? $this->title, // Hotels use 'name' in Astro type
            'location' => $this->location,
            'amenities' => $this->amenities,
            'stars' => (int) $this->stars,
        ];
    }
}
