<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('destinations', function (Blueprint $table) {
            if (!Schema::hasColumn('destinations', 'rating')) {
                $table->decimal('rating', 3, 2)->default(0)->after('country');
            }
            if (!Schema::hasColumn('destinations', 'total_reviews')) {
                $table->integer('total_reviews')->default(0)->after('rating');
            }
        });

        Schema::table('services', function (Blueprint $table) {
            if (!Schema::hasColumn('services', 'rating')) {
                $table->decimal('rating', 3, 2)->default(0)->after('slug');
            }
            if (!Schema::hasColumn('services', 'total_reviews')) {
                $table->integer('total_reviews')->default(0)->after('rating');
            }
            if (!Schema::hasColumn('services', 'stars')) {
                $table->integer('stars')->nullable()->after('total_reviews');
            }
            if (!Schema::hasColumn('services', 'highlights')) {
                $table->json('highlights')->nullable()->after('description');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('destinations', function (Blueprint $table) {
            $table->dropColumn(['rating', 'total_reviews']);
        });

        Schema::table('services', function (Blueprint $table) {
            $table->dropColumn(['rating', 'total_reviews', 'stars', 'highlights']);
        });
    }
};
