<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\TourBooking\App\Models\Destination;
use Modules\TourBooking\App\Models\Service;
use Modules\TourBooking\App\Models\ServiceType;

class AstroDataSeeder extends Seeder
{
    public function run()
    {
        // 1. Seed Destinations (from TopTrending.astro)
        $destinations = [
            [
                'name' => 'Thailand',
                'slug' => 'thailand',
                'country' => 'Thailand',
                'image' => 'https://images.unsplash.com/photo-1552465011-b4e21bf6e79a?w=400&q=80',
                'description' => 'Experience the land of smiles with its beautiful beaches and temples.',
                'rating' => 4.8,
                'total_reviews' => 1250,
                'status' => 1,
                'is_featured' => 1,
                'show_on_homepage' => 1,
                'ordering' => 1,
            ],
            [
                'name' => 'Bali',
                'slug' => 'bali',
                'country' => 'Indonesia',
                'image' => 'https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=400&q=80',
                'description' => 'Island of the Gods, offering scenic rice terraces and fragrant cuisine.',
                'rating' => 4.9,
                'total_reviews' => 2300,
                'status' => 1,
                'is_featured' => 1,
                'show_on_homepage' => 1,
                'ordering' => 2,
            ],
            [
                'name' => 'Vietnam',
                'slug' => 'vietnam',
                'country' => 'Vietnam',
                'image' => 'https://images.unsplash.com/photo-1528127269322-539801943592?w=400&q=80',
                'description' => 'Bustling cities and limestone islands in Halong Bay.',
                'rating' => 4.7,
                'total_reviews' => 980,
                'status' => 1,
                'is_featured' => 1,
                'show_on_homepage' => 1,
                'ordering' => 3,
            ],
            [
                'name' => 'Singapore',
                'slug' => 'singapore',
                'country' => 'Singapore',
                'image' => 'https://images.unsplash.com/photo-1525625293386-3f8f99389edd?w=400&q=80',
                'description' => 'A melting pot of cultures, modern architecture and green spaces.',
                'rating' => 4.8,
                'total_reviews' => 1500,
                'status' => 1,
                'is_featured' => 1,
                'show_on_homepage' => 1,
                'ordering' => 4,
            ],
            [
                'name' => 'Dubai',
                'slug' => 'dubai',
                'country' => 'UAE',
                'image' => 'https://images.unsplash.com/photo-1512453979798-5ea266f8880c?w=400&q=80',
                'description' => 'Luxury shopping, ultramodern architecture and lively nightlife.',
                'rating' => 4.9,
                'total_reviews' => 3100,
                'status' => 1,
                'is_featured' => 1,
                'show_on_homepage' => 1,
                'ordering' => 5,
            ],
            [
                'name' => 'Maldives',
                'slug' => 'maldives',
                'country' => 'Maldives',
                'image' => 'https://images.unsplash.com/photo-1514282401047-d79a71a590e8?w=400&q=80',
                'description' => 'Tropical nation in the Indian Ocean known for its beaches and blue lagoons.',
                'rating' => 5.0,
                'total_reviews' => 850,
                'status' => 1,
                'is_featured' => 1,
                'show_on_homepage' => 1,
                'ordering' => 6,
            ],
        ];

        foreach ($destinations as $destInfo) {
            Destination::updateOrCreate(
                ['slug' => $destInfo['slug']],
                $destInfo
            );
        }

        // 2. Ensure a Service Type exists
        $tourType = ServiceType::firstOrCreate(
            ['slug' => 'tour'],
            ['name' => 'Tour', 'status' => 1]
        );

        // 3. Seed Tours (Services)
        // Creating fake tours linked to destinations
        $tours = [
            [
                'title' => 'Bangkok & Pattaya Escape',
                'slug' => 'bangkok-pattaya-escape',
                'destination_slug' => 'thailand',
                'price_per_person' => 9999,
                'full_price' => 14999,
                'discount_price' => 9999,
                'duration' => '5 Days',
                'image' => 'https://images.unsplash.com/photo-1563492065599-3520f775eeed?w=600&q=80',
                'rating' => 4.5,
                'total_reviews' => 120,
                'stars' => 4,
                'highlights' => json_encode(['Grand Palace', 'Coral Island', 'Floating Market']),
            ],
            [
                'title' => 'Bali Honeymoon Special',
                'slug' => 'bali-honeymoon-special',
                'destination_slug' => 'bali',
                'price_per_person' => 24999,
                'full_price' => 35000,
                'discount_price' => 24999,
                'duration' => '7 Days',
                'image' => 'https://images.unsplash.com/photo-1555400038-63f5ba517a91?w=600&q=80',
                'rating' => 4.9,
                'total_reviews' => 340,
                'stars' => 5,
                'highlights' => json_encode(['Ubud Swing', 'Sunset Dinner', 'Private Pool Villa']),
            ],
            [
                'title' => 'Vietnam Discovery',
                'slug' => 'vietnam-discovery',
                'destination_slug' => 'vietnam',
                'price_per_person' => 19999,
                'full_price' => 28000,
                'discount_price' => 19999,
                'duration' => '6 Days',
                'image' => 'https://images.unsplash.com/photo-1509043759401-136742328bb3?w=600&q=80',
                'rating' => 4.6,
                'total_reviews' => 85,
                'stars' => 4,
                'highlights' => json_encode(['Ha Long Bay Cruise', 'Hanoi Old Quarter', 'Mekong Delta']),
            ]
        ];

        foreach ($tours as $tourData) {
            $destination = Destination::where('slug', $tourData['destination_slug'])->first();

            if ($destination) {
                // Handle image logic or placeholder
                // Clean data for create/update
                $data = $tourData;
                unset($data['destination_slug']);
                unset($data['image']); // In reality we need to handle media table, but for now skipping or using a simple field if exists

                // Assuming Service has 'service_type_id' & 'destination_id'
                $data['destination_id'] = $destination->id;
                $data['service_type_id'] = $tourType->id;
                $data['is_featured'] = 1;
                $data['is_popular'] = 1;
                $data['status'] = 1;
                $data['show_on_homepage'] = 1;

                $service = Service::updateOrCreate(
                    ['slug' => $tourData['slug']],
                    $data
                );

                // If you have a media relation, you might pseudo-attach it here, 
                // but for simplicity, we assume your Resource handles null images gracefully or we set a direct column if added.
            }
        }
    }
}
