<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\Language\App\Models\Language;
use Modules\Currency\App\Models\Currency;

class SystemDataSeeder extends Seeder
{
    public function run()
    {
        // Seed default language
        if (Language::count() == 0) {
            Language::create([
                'lang_name' => 'English',
                'lang_code' => 'en',
                'lang_direction' => 'left_to_right',
                'is_default' => 'Yes',
                'status' => 1,
            ]);
        }

        // Seed default currency
        if (Currency::count() == 0) {
            Currency::create([
                'currency_name' => 'US Dollar',
                'currency_code' => 'USD',
                'country_code' => 'US',
                'currency_icon' => '$',
                'currency_rate' => 1.00,
                'is_default' => 'yes', // Note: 'yes' as per migration default
                'currency_position' => 'before_price',
                'status' => 'active',
            ]);
        }
    }
}
