<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

try {
    $menus = \App\Models\Menu::with([
        'items' => function ($q) {
            $q->orderBy('order');
        }
    ])->get();

    foreach ($menus as $menu) {
        echo "MENU: {$menu->name} (Location: {$menu->location}, ID: {$menu->id})\n";
        foreach ($menu->items as $item) {
            echo "  ITEM: {$item->title} (Parent: {$item->parent_id}, URL: {$item->url})\n";
            if ($item->parameters) {
                echo "    PARAMS: " . json_encode($item->parameters) . "\n";
            }
        }
        echo "---------------------------------\n";
    }
} catch (\Exception $e) {
    echo "ERROR: " . $e->getMessage();
}
