<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

try {
    echo "--- CHECKING ALL MENUS ---\n";
    $allMenus = \App\Models\Menu::all();
    foreach ($allMenus as $m) {
        echo "ID: {$m->id} | Name: {$m->name} | Location: '{$m->location}' | Status: {$m->status}\n";
    }

    echo "\n--- CHECKING API QUERY ---\n";
    $menu = \App\Models\Menu::where('location', 'header')->with([
        'items' => function ($q) {
            $q->where('parent_id', 0)->where('status', 1)->orderBy('order')->with([
                'children' => function ($q2) {
                    $q2->where('status', 1)->orderBy('order');
                }
            ]);
        }
    ])->first();

    if ($menu) {
        echo "API Match Found: YES\n";
        echo "Menu Name: " . $menu->name . "\n";
        echo "Top Level Items: " . $menu->items->count() . "\n";
        foreach ($menu->items as $item) {
            echo " - {$item->title} (Children: " . $item->children->count() . ")\n";
            echo "   Params: " . json_encode($item->parameters) . "\n";
        }
    } else {
        echo "API Match Found: NO (PublicController::header_menu will return empty []\n";
    }

} catch (\Exception $e) {
    echo "Error: " . $e->getMessage();
}
