<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\PublicController;
use App\Http\Controllers\Api\DestinationController;
use App\Http\Controllers\Api\ServiceController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

Route::get('/home', [PublicController::class, 'home']);
Route::get('/header-menu', [PublicController::class, 'header_menu']);

Route::get('/destinations', [DestinationController::class, 'index']);
Route::get('/destinations/trending', [DestinationController::class, 'trending']);
Route::get('/destinations/{id}', [DestinationController::class, 'show']);

Route::get('/services', [ServiceController::class, 'index']);
Route::get('/services/{id}', [ServiceController::class, 'show']);

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
