<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Enquiry;
use App\Models\Package;
use App\Models\Banner;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_packages' => Package::count(),
            'total_banners' => Banner::count(),
            'total_enquiries' => Enquiry::count(),
            'unread_enquiries' => Enquiry::unread()->count(),
        ];

        $recentEnquiries = Enquiry::latest()->take(5)->get();

        return view('admin.dashboard', compact('stats', 'recentEnquiries'));
    }
}
