<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FooterSetting;
use Illuminate\Http\Request;

class FooterController extends Controller
{
    public function edit()
    {
        $settings = FooterSetting::getSettings();
        return view('admin.footer.edit', compact('settings'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'email' => 'nullable|email',
            'phone' => 'nullable|string',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
        ]);

        $settings = FooterSetting::first();

        if (!$settings) {
            $settings = new FooterSetting();
        }

        $data = $request->except('logo', 'gallery_images');

        if ($request->hasFile('logo')) {
            $image = $request->file('logo');
            $imageName = 'logo_' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('images'), $imageName);
            $data['logo'] = 'images/' . $imageName;
        }

        // Handle gallery images as comma-separated string
        if ($request->gallery_images) {
            $data['gallery_images'] = array_filter(array_map('trim', explode(',', $request->gallery_images)));
        }

        $settings->fill($data);
        $settings->save();

        return redirect()->route('admin.footer.edit')->with('success', 'Footer settings updated successfully');
    }
}
