<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SeoSetting;
use Illuminate\Http\Request;

class SeoSettingController extends Controller
{
    public function edit()
    {
        $settings = SeoSetting::getSettings();
        return view('admin.seo-settings.edit', compact('settings'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'meta_title' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:500',
            'meta_keywords' => 'nullable|string|max:500',
            'meta_author' => 'nullable|string|max:100',
            'primary_color' => 'nullable|string|max:10',
            'package_time_bg' => 'nullable|string|max:10',
            'package_time_text' => 'nullable|string|max:10',
            'package_includes_bg' => 'nullable|string|max:10',
            'package_includes_text' => 'nullable|string|max:10',
            'destination_sec_bg' => 'nullable|string|max:10',
        ]);

        $settings = SeoSetting::first();

        if (!$settings) {
            $settings = new SeoSetting();
        }

        $settings->fill($request->only([
            'meta_title',
            'meta_description',
            'meta_keywords',
            'meta_author',
            'primary_color',
            'package_time_bg',
            'package_time_text',
            'package_includes_bg',
            'package_includes_text',
            'destination_sec_bg',
        ]));

        $settings->save();

        return redirect()->route('admin.seo-settings.edit')->with('success', 'SEO settings updated successfully');
    }
}
