<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TrackingCode;
use Illuminate\Http\Request;

class TrackingCodeController extends Controller
{
    public function edit()
    {
        $settings = TrackingCode::getSettings();
        return view('admin.tracking-codes.edit', compact('settings'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'google_analytics_id' => 'nullable|string|max:50',
            'facebook_pixel_id' => 'nullable|string|max:50',
            'google_tag_manager_id' => 'nullable|string|max:50',
            'custom_head_scripts' => 'nullable|string',
        ]);

        $settings = TrackingCode::first();

        if (!$settings) {
            $settings = new TrackingCode();
        }

        $settings->fill($request->only([
            'google_analytics_id',
            'facebook_pixel_id',
            'google_tag_manager_id',
            'custom_head_scripts',
        ]));

        $settings->save();

        return redirect()->route('admin.tracking-codes.edit')->with('success', 'Tracking codes updated successfully');
    }
}
