<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\WhyChooseUs;
use Illuminate\Http\Request;

class WhyChooseUsController extends Controller
{
    public function index()
    {
        $items = WhyChooseUs::orderBy('sort_order')->paginate(10);
        return view('admin.why-choose-us.index', compact('items'));
    }

    public function create()
    {
        return view('admin.why-choose-us.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,avif,webp|max:2048',
        ]);

        $data = $request->except('image');

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('images/why-us'), $imageName);
            $data['image'] = 'images/why-us/' . $imageName;
        }

        WhyChooseUs::create($data);

        return redirect()->route('admin.why-choose-us.index')->with('success', 'Item created successfully');
    }

    public function edit(WhyChooseUs $why_choose_u)
    {
        $item = $why_choose_u;
        return view('admin.why-choose-us.edit', compact('item'));
    }

    public function update(Request $request, WhyChooseUs $why_choose_u)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,avif,webp|max:2048',
        ]);

        $data = $request->except('image');

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('images/why-us'), $imageName);
            $data['image'] = 'images/why-us/' . $imageName;
        }

        $why_choose_u->update($data);

        return redirect()->route('admin.why-choose-us.index')->with('success', 'Item updated successfully');
    }

    public function destroy(WhyChooseUs $why_choose_u)
    {
        $why_choose_u->delete();
        return redirect()->route('admin.why-choose-us.index')->with('success', 'Item deleted successfully');
    }
}
