<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Models\Destination;
use App\Models\Faq;
use App\Models\FooterSetting;
use App\Models\Package;
use App\Models\StaticPage;
use App\Models\WhyChooseUs;
use App\Models\TrackingCode;
use App\Models\SeoSetting;

class HomeController extends Controller
{
    public function index()
    {
        $banners = Banner::active()->ordered()->get();
        $destinations = Destination::active()->ordered()->get();
        $faqs = Faq::active()->ordered()->get();
        $whyChooseUs = WhyChooseUs::active()->ordered()->get();
        $footer = FooterSetting::getSettings();
        $trackingCodes = TrackingCode::getSettings();
        $seoSettings = SeoSetting::getSettings();

        // Group packages by category
        $bestKashmirPackages = Package::active()->byCategory('best_kashmir')->orderBy('sort_order')->get();
        $honeymoonPackages = Package::active()->byCategory('honeymoon')->orderBy('sort_order')->get();
        $adventurePackages = Package::active()->byCategory('adventure')->orderBy('sort_order')->get();
        $culturalPackages = Package::active()->byCategory('cultural')->orderBy('sort_order')->get();

        return view('frontend.home', compact(
            'banners',
            'destinations',
            'faqs',
            'whyChooseUs',
            'footer',
            'trackingCodes',
            'seoSettings',
            'bestKashmirPackages',
            'honeymoonPackages',
            'adventurePackages',
            'culturalPackages'
        ));
    }

    public function staticPage($slug)
    {
        $page = StaticPage::where('slug', $slug)->firstOrFail();
        $footer = FooterSetting::getSettings();
        $seoSettings = SeoSetting::getSettings();

        return view('frontend.pages.static', compact('page', 'footer', 'seoSettings'));
    }
}
