<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FooterSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'logo',
        'tagline',
        'email',
        'phone',
        'address',
        'facebook_url',
        'instagram_url',
        'whatsapp_number',
        'gallery_images',
    ];

    protected function casts(): array
    {
        return [
            'gallery_images' => 'array',
        ];
    }

    public static function getSettings()
    {
        return static::first() ?? new static();
    }
}
