<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Package extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'slug',
        'category',
        'image',
        'duration_days',
        'duration_nights',
        'flights',
        'hotels',
        'activities',
        'transfers',
        'location_tags',
        'itinerary',
        'inclusions',
        'highlights',
        'price',
        'original_price',
        'is_active',
        'sort_order',
    ];

    protected function casts(): array
    {
        return [
            'location_tags' => 'array',
            'itinerary' => 'array',
            'price' => 'decimal:2',
            'original_price' => 'decimal:2',
            'is_active' => 'boolean',
        ];
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($package) {
            if (empty($package->slug)) {
                $package->slug = Str::slug($package->title);
            }
        });
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByCategory($query, $category)
    {
        return $query->where('category', $category);
    }

    public function getDurationAttribute()
    {
        return $this->duration_days . ' Days / ' . $this->duration_nights . ' Night';
    }
}
