<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SeoSetting extends Model
{
    protected $fillable = [
        'meta_title',
        'meta_description',
        'meta_keywords',
        'meta_author',
        'primary_color',
        'package_time_bg',
        'package_time_text',
        'package_includes_bg',
        'package_includes_text',
        'destination_sec_bg',
    ];

    /**
     * Get the SEO settings (singleton pattern)
     */
    public static function getSettings()
    {
        $settings = self::first();

        if (!$settings) {
            $settings = new self();
        }

        return $settings;
    }
}
