<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TrackingCode extends Model
{
    protected $fillable = [
        'google_analytics_id',
        'facebook_pixel_id',
        'google_tag_manager_id',
        'custom_head_scripts',
    ];

    /**
     * Get the tracking code settings (singleton pattern)
     */
    public static function getSettings()
    {
        $settings = self::first();

        if (!$settings) {
            $settings = new self();
        }

        return $settings;
    }
}
