<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->enum('category', ['best_kashmir', 'honeymoon', 'adventure', 'cultural']);
            $table->string('image')->nullable();
            $table->integer('duration_days');
            $table->integer('duration_nights');
            $table->integer('flights')->default(0);
            $table->integer('hotels')->default(0);
            $table->integer('activities')->default(0);
            $table->integer('transfers')->default(0);
            $table->json('location_tags')->nullable();
            $table->json('itinerary')->nullable();
            $table->decimal('price', 10, 2)->nullable();
            $table->decimal('original_price', 10, 2)->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
