<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('seo_settings', function (Blueprint $table) {
            // Package time badge colors
            $table->string('package_time_bg', 10)->nullable()->default('#008746')->after('primary_color');
            $table->string('package_time_text', 10)->nullable()->default('#ffffff')->after('package_time_bg');

            // Package includes tag colors
            $table->string('package_includes_bg', 10)->nullable()->default('#008746')->after('package_time_text');
            $table->string('package_includes_text', 10)->nullable()->default('#ffffff')->after('package_includes_bg');

            // Destination section background
            $table->string('destination_sec_bg', 10)->nullable()->default('#fff5f9')->after('package_includes_text');
        });
    }

    public function down(): void
    {
        Schema::table('seo_settings', function (Blueprint $table) {
            $table->dropColumn([
                'package_time_bg',
                'package_time_text',
                'package_includes_bg',
                'package_includes_text',
                'destination_sec_bg'
            ]);
        });
    }
};
