<?php

namespace Database\Seeders;

use App\Models\Admin;
use App\Models\Banner;
use App\Models\Destination;
use App\Models\Faq;
use App\Models\FooterSetting;
use App\Models\Package;
use App\Models\StaticPage;
use App\Models\WhyChooseUs;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create admin user
        Admin::create([
            'name' => 'Admin',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
        ]);

        // Create banners
        $banners = [
            ['title' => 'Magical Kashmir Tour', 'subtitle' => '5 days & 4 nights | 2N Srinagar • 2N Pahalgam • 1N Gulmarg', 'image' => 'images/landing-banner/1.webp', 'price' => 14999, 'original_price' => 20399, 'sort_order' => 1],
            ['title' => 'Glimpses of Family Tour', 'subtitle' => '4 days & 3 nights | 2N Srinagar • 1N Pahalgam', 'image' => 'images/landing-banner/2.webp', 'price' => 12999, 'original_price' => 15599, 'sort_order' => 2],
            ['title' => 'Beautiful Kashmir in Winters', 'subtitle' => '6 days & 5 nights | 1N Srinagar • 1N Gulmarg', 'image' => 'images/landing-banner/3.webp', 'price' => 13999, 'original_price' => 16799, 'sort_order' => 3],
            ['title' => 'Gurez Valley Tour package', 'subtitle' => '6 days & 5 nights | 1N Srinagar • 2N Gurez • 1Hr Shikara Ride', 'image' => 'images/landing-banner/4.webp', 'price' => 14999, 'original_price' => 17399, 'sort_order' => 4],
            ['title' => 'Best Selling Kashmir Tour', 'subtitle' => '1N Srinagar • 2N Pahalgam • 2N Gulmarg', 'image' => 'images/landing-banner/5.webp', 'price' => 24999, 'original_price' => 29999, 'sort_order' => 5],
        ];
        foreach ($banners as $banner) {
            Banner::create($banner);
        }

        // Create Best Kashmir packages
        $bestKashmirPackages = [
            ['title' => 'Beautiful Kashmir in Winters', 'slug' => 'beautiful-kashmir-winters', 'category' => 'best_kashmir', 'image' => 'images/BeautifulKashmirWinters.png', 'duration_days' => 4, 'duration_nights' => 3, 'flights' => 0, 'hotels' => 3, 'activities' => 6, 'transfers' => 4, 'location_tags' => ['1N Srinagar', '2N Gulmarg'], 'itinerary' => ['01 Hr Shikara Ride', 'Indian Lunch'], 'price' => 13999, 'original_price' => 16799, 'sort_order' => 1],
            ['title' => 'Glimpses of Kashmir Tour', 'slug' => 'glimpses-kashmir-tour', 'category' => 'best_kashmir', 'image' => 'images/Glimpsesofkashmir.png', 'duration_days' => 4, 'duration_nights' => 3, 'flights' => 0, 'hotels' => 3, 'activities' => 6, 'transfers' => 4, 'location_tags' => ['1N Srinagar HB', '1N Pahalgam', '1N Gulmarg'], 'itinerary' => ['01 Hr Shikara Ride', 'Tour to Chandanwari, Aru & Betab Valley IN Pahalgam'], 'price' => 11549, 'original_price' => 13848, 'sort_order' => 2],
            ['title' => 'Kashmir Valley Tour', 'slug' => 'kashmir-valley-tour', 'category' => 'best_kashmir', 'image' => 'images/villagetour.png', 'duration_days' => 4, 'duration_nights' => 3, 'flights' => 0, 'hotels' => 3, 'activities' => 6, 'transfers' => 4, 'location_tags' => ['1N Srinagar HB', '1N Pahalgam', '1N Gulmarg'], 'itinerary' => ['01 Hr Shikara Ride', 'Tour to Chandanwari, Aru & Betab Valley IN Pahalgam'], 'price' => 11999, 'original_price' => 14399, 'sort_order' => 3],
        ];
        foreach ($bestKashmirPackages as $package) {
            Package::create($package);
        }

        // Create Honeymoon packages
        $honeymoonPackages = [
            ['title' => 'Glimpses of Family Tour', 'slug' => 'glimpses-family-tour', 'category' => 'honeymoon', 'image' => 'images/glimpsofkashmir.png', 'duration_days' => 4, 'duration_nights' => 3, 'flights' => 0, 'hotels' => 3, 'activities' => 6, 'transfers' => 4, 'location_tags' => ['2N Srinagar', '1N Gulmarg', '1N Pahalgam'], 'itinerary' => ['01 Hr Shikara Ride', 'Tour to Chandanwari, Aru & Betab Valley IN Pahalgam'], 'price' => 12999, 'original_price' => 15599, 'sort_order' => 1],
            ['title' => 'Magical Kashmir Tour', 'slug' => 'magical-kashmir-tour', 'category' => 'honeymoon', 'image' => 'images/magicalofkashmir.png', 'duration_days' => 5, 'duration_nights' => 4, 'flights' => 0, 'hotels' => 4, 'activities' => 8, 'transfers' => 5, 'location_tags' => ['2N Srinagar (1N HB)', '1N Pahalgam', '1N Gulmarg'], 'itinerary' => ['01 Hr Shikara Ride', 'Tour to Chandanwari, Aru & Betab Valley IN Pahalgam'], 'price' => 15999, 'original_price' => 19199, 'sort_order' => 2],
            ['title' => 'Best Selling Kashmir Tour', 'slug' => 'best-selling-kashmir-honeymoon', 'category' => 'honeymoon', 'image' => 'images/bestsellingtour.png', 'duration_days' => 6, 'duration_nights' => 5, 'flights' => 0, 'hotels' => 5, 'activities' => 9, 'transfers' => 6, 'location_tags' => ['2N Srinagar', '1N Pahalgam', '1N Gulmarg', '1N Srinagar HB'], 'itinerary' => ['01 Hr Shikara Ride', 'Tour to Chandanwari, Aru & Betab Valley IN Pahalgam'], 'price' => 19999, 'original_price' => 23399, 'sort_order' => 3],
        ];
        foreach ($honeymoonPackages as $package) {
            Package::create($package);
        }

        // Create Adventure packages  
        $adventurePackages = [
            ['title' => 'Beautiful Kashmir in Winters', 'slug' => 'beautiful-kashmir-winters-adventure', 'category' => 'adventure', 'image' => 'images/BeautifulKashmirWinters.png', 'duration_days' => 4, 'duration_nights' => 3, 'flights' => 0, 'hotels' => 3, 'activities' => 6, 'transfers' => 4, 'location_tags' => ['1N Srinagar', '2N Gulmarg'], 'itinerary' => ['01 Hr Shikara Ride', 'Indian Lunch'], 'price' => 13999, 'original_price' => 16799, 'sort_order' => 1],
            ['title' => 'Enchanting Kashmir Tour', 'slug' => 'enchanting-kashmir-tour', 'category' => 'adventure', 'image' => 'images/EnchantingKashmirTour.png', 'duration_days' => 5, 'duration_nights' => 4, 'flights' => 0, 'hotels' => 4, 'activities' => 8, 'transfers' => 5, 'location_tags' => ['1N Srinagar', '1N Pahalgam', '2N Gulmarg'], 'itinerary' => ['01 Hr Shikara Ride', 'Indian Lunch'], 'price' => 17999, 'original_price' => 21599, 'sort_order' => 2],
            ['title' => 'Gulmarg Winter Wonderland', 'slug' => 'gulmarg-winter-wonderland', 'category' => 'adventure', 'image' => 'images/Gulmarg Winter Wonderland.png', 'duration_days' => 4, 'duration_nights' => 3, 'flights' => 0, 'hotels' => 3, 'activities' => 6, 'transfers' => 4, 'location_tags' => ['3N Gulmarg'], 'itinerary' => ['01 Hr Shikara Ride', 'Indian Lunch'], 'price' => 15999, 'original_price' => 19199, 'sort_order' => 3],
        ];
        foreach ($adventurePackages as $package) {
            Package::create($package);
        }

        // Create Cultural packages
        $culturalPackages = [
            ['title' => 'Gurez Valley Tour package', 'slug' => 'gurez-valley-tour', 'category' => 'cultural', 'image' => 'images/5.png', 'duration_days' => 4, 'duration_nights' => 3, 'flights' => 0, 'hotels' => 3, 'activities' => 5, 'transfers' => 4, 'location_tags' => ['1N Srinagar (01 IN HB)', '2N Gurez', '1Hr Shikara Ride'], 'itinerary' => ['01 Hr Shikara Ride', 'Indian Lunch'], 'price' => 14999, 'original_price' => 17399, 'sort_order' => 1],
        ];
        foreach ($culturalPackages as $package) {
            Package::create($package);
        }

        // Create destinations
        $destinations = [
            ['name' => 'Srinagar', 'duration' => '4 Nights / 5 Days', 'image' => 'images/destination/new/1.webp', 'sort_order' => 1],
            ['name' => 'Pahalgam', 'duration' => '6 Nights / 7 Days', 'image' => 'images/pahalgamnew.png', 'sort_order' => 2],
            ['name' => 'Gulmarg', 'duration' => '3 Nights / 4 Days', 'image' => 'images/gulmarglanding.png', 'sort_order' => 3],
            ['name' => 'Leh', 'duration' => '8 Nights / 7 Days', 'image' => 'images/lehnewlanding.png', 'sort_order' => 4],
            ['name' => 'Sonamurg', 'duration' => '3 Nights / 4 Days', 'image' => 'images/sonamurg.png', 'sort_order' => 5],
            ['name' => 'Gurez', 'duration' => '3 Nights / 5 Days', 'image' => 'images/gureznew.png', 'sort_order' => 6],
        ];
        foreach ($destinations as $destination) {
            Destination::create($destination);
        }

        // Create FAQs
        $faqs = [
            ['question' => 'How can I plan my Kashmir trip with Fly Divine Treasure?', 'answer' => 'Planning your Kashmir trip is easy with Fly Divine Treasure. You can reach Kashmir by flying to Srinagar International Airport from major Indian cities or by train to Jammu Tawi, followed by a scenic road journey. We assist you with transport, hotels, sightseeing, and complete trip planning.', 'sort_order' => 1],
            ['question' => 'What is the best time to visit Kashmir?', 'answer' => 'The best time to visit Kashmir is from April to October for pleasant weather and sightseeing. Winter months from December to February are ideal for snowfall and winter activities, especially in Gulmarg.', 'sort_order' => 2],
            ['question' => 'How much does a Kashmir tour package cost?', 'answer' => 'Kashmir tour packages usually start from ₹10,000 per person and vary based on trip duration, hotel category, and activities. Fly Divine Treasure offers budget-friendly and fully customizable packages.', 'sort_order' => 3],
            ['question' => 'What is the ideal duration for a Kashmir tour?', 'answer' => 'A 5 to 7-day trip is ideal to explore Kashmir comfortably. This allows enough time to visit Srinagar, Gulmarg, Pahalgam, and Sonamarg without rushing.', 'sort_order' => 4],
            ['question' => 'Can you suggest a 5-day Kashmir itinerary?', 'answer' => '<strong>Day 1:</strong> Arrival in Srinagar and local sightseeing<br><strong>Day 2:</strong> Sonamarg day trip<br><strong>Day 3:</strong> Srinagar to Pahalgam<br><strong>Day 4:</strong> Pahalgam sightseeing<br><strong>Day 5:</strong> Gulmarg excursion and departure from Srinagar', 'sort_order' => 5],
            ['question' => 'Which destinations are covered in Kashmir tour packages?', 'answer' => 'Most Kashmir tour packages cover Srinagar, Gulmarg, Pahalgam, and Sonamarg. Extended itineraries may also include Yusmarg, Doodhpathri, and Kupwara for a more offbeat experience.', 'sort_order' => 6],
            ['question' => 'Are Kashmir tour packages customizable?', 'answer' => 'Yes, all Fly Divine Treasure packages are fully customizable. You can personalize hotels, travel dates, sightseeing options, and activities to match your preferences and budget.', 'sort_order' => 7],
        ];
        foreach ($faqs as $faq) {
            Faq::create($faq);
        }

        // Create Why Choose Us items
        $whyChooseUs = [
            ['image' => 'images/why-us/1.avif', 'title' => '1000+ Happy Travelers', 'description' => 'Creating lifetime memories in the paradise of Kashmir.', 'sort_order' => 1],
            ['image' => 'images/why-us/2.avif', 'title' => '4.6 / 5.0 Excellent Ratings', 'description' => 'Loved and recommended by explorers worldwide.', 'sort_order' => 2],
            ['image' => 'images/why-us/3.avif', 'title' => 'Handpicked Experiences', 'description' => 'Expertly curated trips for an authentic Kashmir adventure.', 'sort_order' => 3],
            ['image' => 'images/why-us/4.avif', 'title' => '24/7 Assistance', 'description' => 'Seamless support before, during, and after your journey.', 'sort_order' => 4],
        ];
        foreach ($whyChooseUs as $item) {
            WhyChooseUs::create($item);
        }

        // Create static pages
        StaticPage::create([
            'slug' => 'privacy-policy',
            'title' => 'Privacy Policy',
            'content' => '<h2>Privacy Policy</h2><p>At flydivinetreasurekash, we are committed to protecting your privacy and ensuring the security of your personal information.</p>',
        ]);

        StaticPage::create([
            'slug' => 'terms-conditions',
            'title' => 'Terms & Conditions',
            'content' => '<h2>Terms & Conditions</h2><p>Please read these terms and conditions carefully before using our services.</p>',
        ]);

        StaticPage::create([
            'slug' => 'cancellation-refunds',
            'title' => 'Cancellation & Refunds',
            'content' => '<h2>Cancellation & Refunds Policy</h2><p>Our cancellation and refund policies are designed to be fair to both our customers and our business.</p>',
        ]);

        // Create footer settings
        FooterSetting::create([
            'logo' => 'images/flydivinetreasurekashlogo.png',
            'tagline' => 'flydivinetreasurekash – Your Gateway to Breathtaking Adventures in the Heart of the Kashmir!',
            'email' => 'info@flydivinetreasurekash.com',
            'phone' => '+91 8899269767',
            'address' => 'Near SB Queens International School Mujgund Srinagar',
            'facebook_url' => 'https://www.facebook.com/share/1GgWyLB9Xv/?mibextid=wwXIfr',
            'instagram_url' => 'https://www.instagram.com/flydivinetreasure?igsh=dGZ5djlydDRrYXNv',
            'gallery_images' => ['images/destination/1.jpg', 'images/destination/2.jpg', 'images/destination/3.jpg', 'images/destination/4.jpg', 'images/destination/5.jpg', 'images/destination/6.jpg'],
        ]);
    }
}
