@extends('admin.layouts.app')

@section('title', 'Banners')

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Homepage Banners</span>
            <a href="{{ route('admin.banners.create') }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus me-1"></i> Add New
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($banners as $banner)
                            <tr>
                                <td>
                                    <img src="{{ asset($banner->image) }}" alt=""
                                        style="width: 100px; height: 60px; object-fit: cover; border-radius: 5px;">
                                </td>
                                <td>
                                    <strong>{{ $banner->title }}</strong><br>
                                    <small class="text-muted">{{ $banner->subtitle }}</small>
                                </td>
                                <td>₹{{ number_format($banner->price) }}</td>
                                <td>
                                    @if($banner->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $banner->sort_order }}</td>
                                <td>
                                    <a href="{{ route('admin.banners.edit', $banner) }}"
                                        class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                    <form action="{{ route('admin.banners.destroy', $banner) }}" method="POST" class="d-inline"
                                        onsubmit="return confirm('Are you sure?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">No banners found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $banners->links() }}
        </div>
    </div>
@endsection