@extends('admin.layouts.app')

@section('title', 'Dashboard')

@section('content')
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-box fa-2x text-primary mb-3"></i>
                    <h3>{{ $stats['total_packages'] }}</h3>
                    <p class="text-muted mb-0">Total Packages</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-images fa-2x text-success mb-3"></i>
                    <h3>{{ $stats['total_banners'] }}</h3>
                    <p class="text-muted mb-0">Total Banners</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-envelope fa-2x text-info mb-3"></i>
                    <h3>{{ $stats['total_enquiries'] }}</h3>
                    <p class="text-muted mb-0">Total Enquiries</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-envelope-open fa-2x text-warning mb-3"></i>
                    <h3>{{ $stats['unread_enquiries'] }}</h3>
                    <p class="text-muted mb-0">Unread Enquiries</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>Recent Enquiries</span>
                    <a href="{{ route('admin.enquiries.index') }}" class="btn btn-sm btn-primary">View All</a>
                </div>
                <div class="card-body">
                    @if($recentEnquiries->count() > 0)
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Package</th>
                                        <th>Mobile</th>
                                        <th>Date</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentEnquiries as $enquiry)
                                        <tr>
                                            <td>{{ $enquiry->name }}</td>
                                            <td>{{ $enquiry->package_name ?? 'N/A' }}</td>
                                            <td>{{ $enquiry->mobile }}</td>
                                            <td>{{ $enquiry->created_at->format('M d, Y') }}</td>
                                            <td>
                                                @if($enquiry->is_read)
                                                    <span class="badge bg-success">Read</span>
                                                @else
                                                    <span class="badge bg-warning">Unread</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-muted text-center py-4">No enquiries yet</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">Quick Actions</div>
                <div class="card-body">
                    <a href="{{ route('admin.packages.create') }}" class="btn btn-outline-primary w-100 mb-2">
                        <i class="fas fa-plus me-2"></i> Add New Package
                    </a>
                    <a href="{{ route('admin.banners.create') }}" class="btn btn-outline-success w-100 mb-2">
                        <i class="fas fa-plus me-2"></i> Add New Banner
                    </a>
                    <a href="{{ route('admin.destinations.create') }}" class="btn btn-outline-info w-100 mb-2">
                        <i class="fas fa-plus me-2"></i> Add New Destination
                    </a>
                    <a href="{{ route('admin.faqs.create') }}" class="btn btn-outline-warning w-100">
                        <i class="fas fa-plus me-2"></i> Add New FAQ
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection