@extends('admin.layouts.app')
@section('title', 'Edit Destination')
@section('content')
    <div class="card">
        <div class="card-header">Edit: {{ $destination->name }}</div>
        <div class="card-body">
            <form action="{{ route('admin.destinations.update', $destination) }}" method="POST"
                enctype="multipart/form-data">
                @csrf @method('PUT')
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3"><label class="form-label">Name *</label><input type="text" name="name"
                                class="form-control" value="{{ old('name', $destination->name) }}" required></div>
                        <div class="mb-3"><label class="form-label">Duration</label><input type="text" name="duration"
                                class="form-control" value="{{ old('duration', $destination->duration) }}"></div>
                        <div class="mb-3"><label class="form-label">Description</label><textarea name="description"
                                class="form-control" rows="3">{{ old('description', $destination->description) }}</textarea>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3"><label class="form-label">Image</label>@if($destination->image)
                            <div class="mb-2"><img src="{{ asset($destination->image) }}" alt="" class="img-thumbnail"
                        style="max-width: 150px;"></div>@endif<input type="file" name="image"
                                class="form-control" accept="image/*">
                        </div>
                        <div class="mb-3"><label class="form-label">Sort Order</label><input type="number" name="sort_order"
                                class="form-control" value="{{ old('sort_order', $destination->sort_order) }}"></div>
                        <div class="mb-3">
                            <div class="form-check"><input type="checkbox" name="is_active" class="form-check-input"
                                    value="1" {{ $destination->is_active ? 'checked' : '' }}><label
                                    class="form-check-label">Active</label></div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update</button>
                <a href="{{ route('admin.destinations.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
@endsection