@extends('admin.layouts.app')
@section('title', 'Destinations')
@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Destinations</span>
            <a href="{{ route('admin.destinations.create') }}" class="btn btn-primary btn-sm"><i
                    class="fas fa-plus me-1"></i> Add New</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Duration</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($destinations as $destination)
                            <tr>
                                <td><img src="{{ asset($destination->image) }}" alt=""
                                        style="width: 80px; height: 50px; object-fit: cover; border-radius: 5px;"></td>
                                <td>{{ $destination->name }}</td>
                                <td>{{ $destination->duration }}</td>
                                <td>@if($destination->is_active)<span class="badge bg-success">Active</span>@else<span
                                class="badge bg-secondary">Inactive</span>@endif</td>
                                <td>
                                    <a href="{{ route('admin.destinations.edit', $destination) }}"
                                        class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                    <form action="{{ route('admin.destinations.destroy', $destination) }}" method="POST"
                                        class="d-inline" onsubmit="return confirm('Are you sure?')">@csrf
                                        @method('DELETE')<button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button></form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-4 text-muted">No destinations found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $destinations->links() }}
        </div>
    </div>
@endsection