@extends('admin.layouts.app')
@section('title', 'Enquiries')
@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Customer Enquiries</span>
            <div>
                <a href="{{ route('admin.enquiries.index') }}"
                    class="btn btn-sm {{ !request('status') ? 'btn-primary' : 'btn-outline-secondary' }}">All</a>
                <a href="{{ route('admin.enquiries.index', ['status' => 'unread']) }}"
                    class="btn btn-sm {{ request('status') == 'unread' ? 'btn-primary' : 'btn-outline-secondary' }}">Unread</a>
                <a href="{{ route('admin.enquiries.index', ['status' => 'read']) }}"
                    class="btn btn-sm {{ request('status') == 'read' ? 'btn-primary' : 'btn-outline-secondary' }}">Read</a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Package</th>
                            <th>Contact</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($enquiries as $enquiry)
                            <tr class="{{ !$enquiry->is_read ? 'table-warning' : '' }}">
                                <td><strong>{{ $enquiry->name }}</strong></td>
                                <td>{{ $enquiry->package_name ?? '-' }}</td>
                                <td>{{ $enquiry->mobile }}<br><small class="text-muted">{{ $enquiry->email }}</small></td>
                                <td>{{ $enquiry->created_at->format('M d, Y') }}<br><small
                                        class="text-muted">{{ $enquiry->created_at->format('h:i A') }}</small></td>
                                <td>@if($enquiry->is_read)<span class="badge bg-success">Read</span>@else<span
                                class="badge bg-warning">Unread</span>@endif</td>
                                <td>
                                    <a href="{{ route('admin.enquiries.show', $enquiry) }}"
                                        class="btn btn-sm btn-outline-info"><i class="fas fa-eye"></i></a>
                                    <form action="{{ route('admin.enquiries.destroy', $enquiry) }}" method="POST"
                                        class="d-inline" onsubmit="return confirm('Are you sure?')">@csrf
                                        @method('DELETE')<button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button></form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">No enquiries found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $enquiries->links() }}
        </div>
    </div>
@endsection