@extends('admin.layouts.app')
@section('title', 'View Enquiry')
@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Enquiry Details</span>
            <a href="{{ route('admin.enquiries.index') }}" class="btn btn-sm btn-secondary"><i
                    class="fas fa-arrow-left me-1"></i> Back</a>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <th width="150">Name:</th>
                            <td>{{ $enquiry->name }}</td>
                        </tr>
                        <tr>
                            <th>Email:</th>
                            <td><a href="mailto:{{ $enquiry->email }}">{{ $enquiry->email }}</a></td>
                        </tr>
                        <tr>
                            <th>Mobile:</th>
                            <td><a href="tel:{{ $enquiry->mobile }}">{{ $enquiry->mobile }}</a></td>
                        </tr>
                        <tr>
                            <th>Package:</th>
                            <td>{{ $enquiry->package_name ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Persons:</th>
                            <td>{{ $enquiry->persons ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Booking Date:</th>
                            <td>{{ $enquiry->booking_date ? $enquiry->booking_date->format('M d, Y') : '-' }}</td>
                        </tr>
                        <tr>
                            <th>Submitted:</th>
                            <td>{{ $enquiry->created_at->format('M d, Y h:i A') }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <div class="card bg-light">
                        <div class="card-header">Message</div>
                        <div class="card-body">{{ $enquiry->message ?? 'No message provided' }}</div>
                    </div>
                </div>
            </div>
            <hr>
            <form action="{{ route('admin.enquiries.destroy', $enquiry) }}" method="POST" class="d-inline"
                onsubmit="return confirm('Are you sure you want to delete this enquiry?')">
                @csrf @method('DELETE')
                <button type="submit" class="btn btn-danger"><i class="fas fa-trash me-1"></i> Delete Enquiry</button>
            </form>
        </div>
    </div>
@endsection