@extends('admin.layouts.app')
@section('title', 'Edit FAQ')
@section('content')
    <div class="card">
        <div class="card-header">Edit FAQ</div>
        <div class="card-body">
            <form action="{{ route('admin.faqs.update', $faq) }}" method="POST">
                @csrf @method('PUT')
                <div class="mb-3"><label class="form-label">Question *</label><input type="text" name="question"
                        class="form-control" value="{{ old('question', $faq->question) }}" required></div>
                <div class="mb-3"><label class="form-label">Answer *</label><textarea name="answer" class="form-control"
                        rows="5" required>{{ old('answer', $faq->answer) }}</textarea></div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3"><label class="form-label">Sort Order</label><input type="number" name="sort_order"
                                class="form-control" value="{{ old('sort_order', $faq->sort_order) }}"></div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3 pt-4">
                            <div class="form-check"><input type="checkbox" name="is_active" class="form-check-input"
                                    value="1" {{ $faq->is_active ? 'checked' : '' }}><label
                                    class="form-check-label">Active</label></div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update</button>
                <a href="{{ route('admin.faqs.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
@endsection