@extends('admin.layouts.app')
@section('title', 'FAQs')
@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>FAQs</span>
            <a href="{{ route('admin.faqs.create') }}" class="btn btn-primary btn-sm"><i class="fas fa-plus me-1"></i> Add
                New</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Question</th>
                            <th>Status</th>
                            <th>Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($faqs as $faq)
                            <tr>
                                <td>{{ Str::limit($faq->question, 60) }}</td>
                                <td>@if($faq->is_active)<span class="badge bg-success">Active</span>@else<span
                                class="badge bg-secondary">Inactive</span>@endif</td>
                                <td>{{ $faq->sort_order }}</td>
                                <td>
                                    <a href="{{ route('admin.faqs.edit', $faq) }}" class="btn btn-sm btn-outline-primary"><i
                                            class="fas fa-edit"></i></a>
                                    <form action="{{ route('admin.faqs.destroy', $faq) }}" method="POST" class="d-inline"
                                        onsubmit="return confirm('Are you sure?')">@csrf @method('DELETE')<button type="submit"
                                            class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button></form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center py-4 text-muted">No FAQs found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $faqs->links() }}
        </div>
    </div>
@endsection