@extends('admin.layouts.app')

@section('title', 'Create Package')

@section('content')
    <div class="card">
        <div class="card-header">Create New Package</div>
        <div class="card-body">
            <form action="{{ route('admin.packages.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label class="form-label">Title *</label>
                            <input type="text" name="title" class="form-control" value="{{ old('title') }}" required>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Category *</label>
                                    <select name="category" class="form-select" required>
                                        <option value="best_kashmir">Best Kashmir</option>
                                        <option value="honeymoon">Honeymoon</option>
                                        <option value="adventure">Adventure</option>
                                        <option value="cultural">Cultural</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Days *</label>
                                    <input type="number" name="duration_days" class="form-control"
                                        value="{{ old('duration_days', 3) }}" min="1" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Nights *</label>
                                    <input type="number" name="duration_nights" class="form-control"
                                        value="{{ old('duration_nights', 2) }}" min="0" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Flights</label>
                                    <input type="number" name="flights" class="form-control" value="{{ old('flights', 0) }}"
                                        min="0">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Hotels</label>
                                    <input type="number" name="hotels" class="form-control" value="{{ old('hotels', 0) }}"
                                        min="0">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Activities</label>
                                    <input type="number" name="activities" class="form-control"
                                        value="{{ old('activities', 0) }}" min="0">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Transfers</label>
                                    <input type="number" name="transfers" class="form-control"
                                        value="{{ old('transfers', 0) }}" min="0">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Price (₹)</label>
                                    <input type="number" name="price" class="form-control" value="{{ old('price') }}"
                                        step="0.01">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Original Price (₹) (Per Person Price)</label>
                                    <input type="number" name="original_price" class="form-control"
                                        value="{{ old('original_price') }}" step="0.01">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Location (comma separated)</label>
                            <textarea name="inclusions" class="form-control" rows="2"
                                placeholder="2N Srinagar (01 IN HB),2N Pahalgam,1N Gulmarg">{{ old('inclusions') }}</textarea>
                            <small class="text-muted">Items that are included in the package</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Itinerary (comma separated & one per line)</label>
                            <textarea name="highlights" class="form-control" rows="2"
                                placeholder="01 Hr Shikara Ride,Tour to Chandanwari Aru & Betab Valley IN Pahalgam">{{ old('highlights') }}</textarea>
                            <small class="text-muted">Key highlights of the package</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label bg-danger p-2 text-white rounded">Image: Use 600 x 600 Px Size For
                                Image</label>
                            <input type="file" name="image" class="form-control" accept="image/*">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sort Order</label>
                            <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', 0) }}">
                        </div>
                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="is_active" class="form-check-input" value="1" checked>
                                <label class="form-check-label">Active</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Save Package</button>
                    <a href="{{ route('admin.packages.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection