@extends('admin.layouts.app')

@section('title', 'Packages')

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>All Packages</span>
            <a href="{{ route('admin.packages.create') }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus me-1"></i> Add New
            </a>
        </div>
        <div class="card-body">
            <div class="mb-3">
                <form action="" method="GET" class="d-flex gap-2">
                    <select name="category" class="form-select form-select-sm" style="width: 200px;">
                        <option value="">All Categories</option>
                        <option value="best_kashmir" {{ request('category') == 'best_kashmir' ? 'selected' : '' }}>Best
                            Kashmir</option>
                        <option value="honeymoon" {{ request('category') == 'honeymoon' ? 'selected' : '' }}>Honeymoon
                        </option>
                        <option value="adventure" {{ request('category') == 'adventure' ? 'selected' : '' }}>Adventure
                        </option>
                        <option value="cultural" {{ request('category') == 'cultural' ? 'selected' : '' }}>Cultural</option>
                    </select>
                    <button type="submit" class="btn btn-sm btn-secondary">Filter</button>
                </form>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Category</th>
                            <th>Duration</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($packages as $package)
                            <tr>
                                <td>
                                    @if($package->image)
                                        <img src="{{ asset($package->image) }}" alt=""
                                            style="width: 60px; height: 40px; object-fit: cover; border-radius: 5px;">
                                    @else
                                        <span class="text-muted">No image</span>
                                    @endif
                                </td>
                                <td>{{ $package->title }}</td>
                                <td><span class="badge bg-info">{{ ucfirst(str_replace('_', ' ', $package->category)) }}</span>
                                </td>
                                <td>{{ $package->duration_days }}D / {{ $package->duration_nights }}N</td>
                                <td>₹{{ number_format($package->price) }}</td>
                                <td>
                                    @if($package->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.packages.edit', $package) }}"
                                        class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                    <form action="{{ route('admin.packages.destroy', $package) }}" method="POST"
                                        class="d-inline" onsubmit="return confirm('Are you sure?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-4 text-muted">No packages found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $packages->links() }}
        </div>
    </div>
@endsection