@extends('admin.layouts.app')
@section('title', 'Edit Page')
@section('content')
    <div class="card">
        <div class="card-header">Edit: {{ $staticPage->title }}</div>
        <div class="card-body">
            <form action="{{ route('admin.static-pages.update', $staticPage) }}" method="POST">
                @csrf @method('PUT')
                <div class="mb-3"><label class="form-label">Title *</label><input type="text" name="title"
                        class="form-control" value="{{ old('title', $staticPage->title) }}" required></div>
                <div class="mb-3"><label class="form-label">Content *</label><textarea name="content" class="form-control"
                        rows="15" required>{{ old('content', $staticPage->content) }}</textarea><small
                        class="text-muted">HTML is supported</small></div>

                <hr class="my-4">
                <h5 class="mb-3"><i class="fas fa-search me-2"></i>SEO Settings</h5>

                <div class="mb-3">
                    <label class="form-label">SEO Title</label>
                    <input type="text" name="meta_title" class="form-control"
                        value="{{ old('meta_title', $staticPage->meta_title) }}"
                        placeholder="Leave empty to use page title">
                    <small class="text-muted">Recommended: 50-60 characters. If empty, the page title will be used.</small>
                </div>

                <div class="mb-3">
                    <label class="form-label">SEO Description</label>
                    <textarea name="meta_description" class="form-control" rows="2"
                        placeholder="Brief description for search engines">{{ old('meta_description', $staticPage->meta_description) }}</textarea>
                    <small class="text-muted">Recommended: 150-160 characters</small>
                </div>

                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update</button>
                <a href="{{ route('admin.static-pages.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
@endsection