@extends('admin.layouts.app')
@section('title', 'Static Pages')
@section('content')
    <div class="card">
        <div class="card-header">Static Pages</div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Slug</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($pages as $page)
                            <tr>
                                <td>{{ $page->title }}</td>
                                <td><code>{{ $page->slug }}</code></td>
                                <td><a href="{{ route('admin.static-pages.edit', $page) }}"
                                        class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i> Edit</a></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection