@extends('admin.layouts.app')
@section('title', 'Edit Item')
@section('content')
    <div class="card">
        <div class="card-header">Edit: {{ $item->title }}</div>
        <div class="card-body">
            <form action="{{ route('admin.why-choose-us.update', $item) }}" method="POST" enctype="multipart/form-data">
                @csrf @method('PUT')
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3"><label class="form-label">Title *</label><input type="text" name="title"
                                class="form-control" value="{{ old('title', $item->title) }}" required></div>
                        <div class="mb-3"><label class="form-label">Description *</label><textarea name="description"
                                class="form-control" rows="4"
                                required>{{ old('description', $item->description) }}</textarea></div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3"><label class="form-label">Icon/Image</label>@if($item->image)
                            <div class="mb-2"><img src="{{ asset($item->image) }}" alt="" class="img-thumbnail"
                        style="max-width: 100px;"></div>@endif<input type="file" name="image"
                                class="form-control" accept="image/*">
                        </div>
                        <div class="mb-3"><label class="form-label">Sort Order</label><input type="number" name="sort_order"
                                class="form-control" value="{{ old('sort_order', $item->sort_order) }}"></div>
                        <div class="mb-3">
                            <div class="form-check"><input type="checkbox" name="is_active" class="form-check-input"
                                    value="1" {{ $item->is_active ? 'checked' : '' }}><label
                                    class="form-check-label">Active</label></div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update</button>
                <a href="{{ route('admin.why-choose-us.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
@endsection