@extends('admin.layouts.app')
@section('title', 'Why Choose Us')
@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Why Choose Us Items</span>
            <a href="{{ route('admin.why-choose-us.create') }}" class="btn btn-primary btn-sm"><i
                    class="fas fa-plus me-1"></i> Add New</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Status</th>
                            <th>Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($items as $item)
                            <tr>
                                <td>@if($item->image)<img src="{{ asset($item->image) }}" alt=""
                                style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;">@else<span
                                        class="text-muted">-</span>@endif</td>
                                <td><strong>{{ $item->title }}</strong><br><small
                                        class="text-muted">{{ Str::limit($item->description, 50) }}</small></td>
                                <td>@if($item->is_active)<span class="badge bg-success">Active</span>@else<span
                                class="badge bg-secondary">Inactive</span>@endif</td>
                                <td>{{ $item->sort_order }}</td>
                                <td>
                                    <a href="{{ route('admin.why-choose-us.edit', $item) }}"
                                        class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                    <form action="{{ route('admin.why-choose-us.destroy', $item) }}" method="POST"
                                        class="d-inline" onsubmit="return confirm('Are you sure?')">@csrf
                                        @method('DELETE')<button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button></form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-4 text-muted">No items found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $items->links() }}
        </div>
    </div>
@endsection