<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="UTF-8">

    <!-- Meta Title -->
    <title>
        {{ $seoSettings->meta_title ?? 'Best Kashmir Tour Packages | Explore Paradise on Earth | flydivinetreasure' }}
    </title>

    <!-- Meta Description -->
    <meta name="description"
        content="{{ $seoSettings->meta_description ?? 'Explore Kashmir with flydivinetreasure\'s affordable tour packages. Stay in Dal Lake houseboats, enjoy skiing in Gulmarg, and experience Pahalgam adventures. Book your Kashmir trip today!' }}">

    <!-- Meta Keywords (Optional but included for reference) -->
    <meta name="keywords"
        content="{{ $seoSettings->meta_keywords ?? 'Kashmir tour packages, Kashmir travel guide, best places to visit in Kashmir, Dal Lake houseboats, Gulmarg skiing, Pahalgam tours, Srinagar sightseeing, Kashmir tourism, Kashmir holiday packages, Sonmarg trekking, Kashmir honeymoon, affordable Kashmir trips' }}">

    <!-- Other Important Meta Tags -->
    <meta name="author" content="{{ $seoSettings->meta_author ?? 'flydivinetreasure' }}">
    <meta name="robots" content="index, follow">
    <link rel="icon" type="image/png" href="/images/flydivinetreasurekashlogo.png">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/swiper/css/swiper.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
    <meta name="facebook-domain-verification" content="nrt8ku11aokj5vdm95cyi8h7z1lva1" />

    {{-- Dynamic Theme Colors --}}
    @php 
        $primaryColor = $seoSettings->primary_color ?? '#008746';
        $packageTimeBg = $seoSettings->package_time_bg ?? '#008746';
        $packageTimeText = $seoSettings->package_time_text ?? '#ffffff';
        $packageIncludesBg = $seoSettings->package_includes_bg ?? '#008746';
        $packageIncludesText = $seoSettings->package_includes_text ?? '#ffffff';
        $destinationSecBg = $seoSettings->destination_sec_bg ?? '#fff5f9';
    @endphp
    <style>
        :root {
            --primary-color: {{ $primaryColor }};
        }
        .header-right-tabs .nav-link { color: {{ $primaryColor }}; }
        .header-right-tabs .nav-link.active { background-color: {{ $primaryColor }} !important; color: #fff !important; }
        .package-box .table td i { color: {{ $primaryColor }}; }
        .package-time { background-color: {{ $packageTimeBg }}; color: {{ $packageTimeText }}; }
        .package-includes ul li span { background-color: {{ $packageIncludesBg }}; color: {{ $packageIncludesText }}; }
        .pricing-content .btn:hover { color: {{ $primaryColor }}; }
        .about-content h4 { color: {{ $primaryColor }}; }
        .quote-text::before { background-color: {{ $primaryColor }}; }
        .about-lists ul li i { color: {{ $primaryColor }}; }
        .overview-section .accordion-button i { color: {{ $primaryColor }}; }
        .btn-primary { background-color: {{ $primaryColor }} !important; border-color: {{ $primaryColor }} !important; }
        .btn-primary:hover { background-color: transparent !important; color: {{ $primaryColor }} !important; border-color: {{ $primaryColor }} !important; }
        .destination-sec { background-color: {{ $destinationSecBg }} !important; }
    </style>

    {{-- Google Tag Manager --}}
    @if($trackingCodes->google_tag_manager_id)
        <script>(function (w, d, s, l, i) {
                w[l] = w[l] || []; w[l].push({
                    'gtm.start':
                        new Date().getTime(), event: 'gtm.js'
                }); var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : ''; j.async = true; j.src =
                        'https://www.googletagmanager.com/gtm.js?id=' + i + dl; f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '{{ $trackingCodes->google_tag_manager_id }}');</script>
    @endif

    {{-- Google Analytics --}}
    @if($trackingCodes->google_analytics_id)
        <script async src="https://www.googletagmanager.com/gtag/js?id={{ $trackingCodes->google_analytics_id }}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() { dataLayer.push(arguments); }
            gtag('js', new Date());
            gtag('config', '{{ $trackingCodes->google_analytics_id }}');
        </script>
    @endif

    {{-- Facebook Pixel --}}
    @if($trackingCodes->facebook_pixel_id)
        <script>
            !function (f, b, e, v, n, t, s) {
                if (f.fbq) return; n = f.fbq = function () {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n; n.push = n; n.loaded = !0; n.version = '2.0';
                n.queue = []; t = b.createElement(e); t.async = !0;
                t.src = v; s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '{{ $trackingCodes->facebook_pixel_id }}');
            fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id={{ $trackingCodes->facebook_pixel_id }}&ev=PageView&noscript=1" /></noscript>
    @endif

    {{-- Custom Head Scripts --}}
    @if($trackingCodes->custom_head_scripts)
        {!! $trackingCodes->custom_head_scripts !!}
    @endif
</head>

<body>
    {{-- Google Tag Manager (noscript) - Dynamic --}}
    @if($trackingCodes->google_tag_manager_id)
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ $trackingCodes->google_tag_manager_id }}"
                height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    @endif

    <header class="header">
        <div class="header-bottom">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-2 col-5 order-lg-1">
                        <div class="header-logo">
                            <a href="{{ url('/') }}">
                                <img src="{{ asset($footer->logo ?? 'images/flydivinetreasurekashlogo.png') }}"
                                    alt="logo">
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-7 order-lg-3">
                        <div class="header-right-tabs text-end">
                            <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                <li class="nav-item text-left" role="presentation">
                                    <a href="tel:{{ $footer->phone ?? '+918899269767' }}"
                                        class="nav-link active text-center">Call Us</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a href="javascript:void(0)" class="nav-link" data-bs-toggle="modal"
                                        data-bs-target="#exampleModal">Book Now</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-7 order-lg-2">
                        <div class="header-nav">
                            <div class="swiper-container mySwiper">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#bestpackage">
                                                <img src="{{ asset('images/kashmir-header-icon.png') }}" width="32px">
                                                <p>Best Kashmir</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#Honeymoonpackage">
                                                <img src="{{ asset('images/honeymoon-headericon.png') }}" width="32px">
                                                <p>Honeymoon</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#Kashmiradventure">
                                                <img src="{{ asset('images/advantureheadericon.png') }}" width="32px">
                                                <p>Adventure</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#Cultural">
                                                <img src="{{ asset('images/culturalheadericon.png') }}" width="32px">
                                                <p>Cultural</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#Destinations">
                                                <img src="{{ asset('images/destinationheadericon.png') }}" width="32px">
                                                <p>Destinations</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#faq">
                                                <img src="{{ asset('images/faqheadericon.png') }}" width="32px">
                                                <p>FAQ</p>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Banner Section -->
    <section class="landing-banner-sec">
        <div class="swiper-container banner-slider">
            <div class="swiper-wrapper">
                @foreach($banners as $banner)
                    <div class="swiper-slide">
                        <div class="banner-content bg-cover" style="background-image: url('{{ asset($banner->image) }}');">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="banner-content-area">
                                            <h2>{{ $banner->title }}</h2>
                                            <h4>{!! $banner->subtitle !!}</h4>
                                            <div class="gradient-hr"></div>
                                            <h3>INR {{ number_format($banner->price) }}
                                                @if($banner->original_price)
                                                    <del>INR {{ number_format($banner->original_price) }}</del>
                                                @endif
                                            </h3>
                                            <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                                data-bs-toggle="modal" data-bs-target="#exampleModal"
                                                data-package="{{ $banner->title }}">
                                                {{ $banner->cta_text ?? 'Chat With Expert' }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>

        <!-- Booking Form -->
        <div class="banner-form">
            <div class="container">
                <div class="row align-items-center justify-content-between">
                    <div class="col-lg-6"></div>
                    <div class="col-lg-4">
                        <div class="booking-form">
                            <form action="{{ route('enquiry.store') }}" method="POST" id="bannerForm">
                                @csrf
                                <div class="form-group">
                                    <label>Your Name</label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter full name"
                                        required pattern="[A-Za-z\s]+" title="Please enter only letters and spaces">
                                </div>
                                <div class="form-group">
                                    <label>Your Mobile Number</label>
                                    <input type="tel" name="mobile" class="form-control"
                                        placeholder="Enter 10 digit mobile number" required pattern="[0-9]{10}"
                                        maxlength="10" minlength="10"
                                        title="Please enter exactly 10 digit mobile number"
                                        oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                </div>
                                <div class="form-group">
                                    <label>Your Email Id</label>
                                    <input type="email" name="email" class="form-control" placeholder="Enter email id"
                                        required title="Please enter a valid email address with @">
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Number of Person</label>
                                            <input type="number" name="persons" class="form-control"
                                                placeholder="Enter number of person" min="1" required
                                                title="Please enter at least 1 person"
                                                oninput="if(this.value < 1) this.value = 1">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Booking Date</label>
                                            <input type="date" name="booking_date" class="form-control booking-date"
                                                required title="Please select a future date">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Message</label>
                                    <textarea name="message" class="form-control" rows="4"
                                        placeholder="Enter your message"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary btn-main">Book Your Tour</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Packages Table Section -->
    <section id="Packages" class="section-pad">
        <div class="container">
            <div class="section-header text-center">
                <h3>Kashmir Tour Packages</h3>
            </div>
            <div class="row">
                @if($bestKashmirPackages->count() > 0 || $honeymoonPackages->count() > 0)
                    <div class="col-lg-6">
                        <div class="package-box">
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <tr>
                                        <th>Package Name</th>
                                        <th>Nights</th>
                                        <th>Price (₹)</th>
                                        <th></th>
                                    </tr>
                                    @foreach($bestKashmirPackages->take(6) as $package)
                                        <tr>
                                            <td><i class="fa-solid fa-plane-departure"></i> {{ $package->title }}</td>
                                            <td><i class="fa-solid fa-hotel"></i> {{ $package->duration_nights }} Nights</td>
                                            <td>Rs. {{ number_format($package->price) }}</td>
                                            <td>
                                                <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                                    data-bs-toggle="modal" data-bs-target="#exampleModal"
                                                    data-package="{{ $package->title }}">Book Now</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="package-box">
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <tr>
                                        <th>Package Name</th>
                                        <th>Nights</th>
                                        <th>Price (₹)</th>
                                        <th></th>
                                    </tr>
                                    @foreach($honeymoonPackages->take(6) as $package)
                                        <tr>
                                            <td><i class="fa-solid fa-plane-departure"></i> {{ $package->title }}</td>
                                            <td><i class="fa-solid fa-hotel"></i> {{ $package->duration_nights }} Nights</td>
                                            <td>Rs. {{ number_format($package->price) }}</td>
                                            <td>
                                                <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                                    data-bs-toggle="modal" data-bs-target="#exampleModal"
                                                    data-package="{{ $package->title }}">Book Now</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </table>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </section>

    <!-- Best Kashmir Packages Section -->
    @if($bestKashmirPackages->count() > 0)
        <section id="bestpackage" class="section-pad pt-0">
            <div class="container">
                <div class="section-header text-center">
                    <h3>Best Kashmir Packages</h3>
                </div>
                <div class="swiper-container destination-slider">
                    <div class="swiper-wrapper">
                        @foreach($bestKashmirPackages as $package)
                            <div class="swiper-slide">
                                <div class="pricing-box">
                                    <div class="pricing-img">
                                        <img src="{{ asset($package->image) }}" alt="{{ $package->title }}">
                                    </div>
                                    <div class="pricing-content">
                                        <span class="package-time">
                                            <i class="fa-regular fa-calendar"></i> {{ $package->duration_days }} Days /
                                            {{ $package->duration_nights }} Night
                                        </span>
                                        <h4>{{ $package->title }}</h4>
                                        <div class="features">
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/1.png') }}" alt="">
                                                <p>{{ $package->flights ?? 0 }} Flights</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/2.png') }}" alt="">
                                                <p>{{ $package->hotels ?? 0 }} Hotels</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/3.png') }}" alt="">
                                                <p>{{ $package->activities ?? 0 }} Activities</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/4.png') }}" alt="">
                                                <p>{{ $package->transfers ?? 0 }} Transfers</p>
                                            </div>
                                        </div>
                                        @if($package->inclusions)
                                            <div class="package-includes">
                                                <ul>
                                                    @foreach(explode(',', $package->inclusions) as $inclusion)
                                                        <li><span>{{ trim($inclusion) }}</span></li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        @if($package->highlights)
                                            <div class="others-feature">
                                                <ul>
                                                    @foreach(explode(',', $package->highlights) as $highlight)
                                                        <li>{{ trim($highlight) }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        <h3>₹{{ number_format($package->price) }} <sup>Per person</sup></h3>
                                        @if($package->original_price)
                                            <h5><del>₹{{ number_format($package->original_price) }}</del>
                                                <span>{{ round((($package->original_price - $package->price) / $package->original_price) * 100) }}%
                                                    OFF</span>
                                            </h5>
                                        @endif
                                        <p class="updated-date">Updated on: {{ $package->updated_at->format('d F Y') }}</p>
                                        <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal"
                                            data-package="{{ $package->title }}">
                                            Customised & Send Enquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </section>
    @endif

    <!-- Honeymoon Special Section -->
    @if($honeymoonPackages->count() > 0)
        <section id="Honeymoonpackage" class="section-pad pt-0">
            <div class="container">
                <div class="section-header text-center">
                    <h3>Honeymoon Special</h3>
                </div>
                <div class="swiper-container destination-slider">
                    <div class="swiper-wrapper">
                        @foreach($honeymoonPackages as $package)
                            <div class="swiper-slide">
                                <div class="pricing-box">
                                    <div class="pricing-img">
                                        <img src="{{ asset($package->image) }}" alt="{{ $package->title }}">
                                    </div>
                                    <div class="pricing-content">
                                        <span class="package-time">
                                            <i class="fa-regular fa-calendar"></i> {{ $package->duration_days }} Days /
                                            {{ $package->duration_nights }} Night
                                        </span>
                                        <h4>{{ $package->title }}</h4>
                                        <div class="features">
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/1.png') }}" alt="">
                                                <p>{{ $package->flights ?? 0 }} Flights</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/2.png') }}" alt="">
                                                <p>{{ $package->hotels ?? 0 }} Hotels</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/3.png') }}" alt="">
                                                <p>{{ $package->activities ?? 0 }} Activities</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/4.png') }}" alt="">
                                                <p>{{ $package->transfers ?? 0 }} Transfers</p>
                                            </div>
                                        </div>
                                        @if($package->inclusions)
                                            <div class="package-includes">
                                                <ul>
                                                    @foreach(explode(',', $package->inclusions) as $inclusion)
                                                        <li><span>{{ trim($inclusion) }}</span></li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        @if($package->highlights)
                                            <div class="others-feature">
                                                <ul>
                                                    @foreach(explode(',', $package->highlights) as $highlight)
                                                        <li>{{ trim($highlight) }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        <h3>₹{{ number_format($package->price) }} <sup>Per person</sup></h3>
                                        @if($package->original_price)
                                            <h5><del>₹{{ number_format($package->original_price) }}</del>
                                                <span>{{ round((($package->original_price - $package->price) / $package->original_price) * 100) }}%
                                                    OFF</span>
                                            </h5>
                                        @endif
                                        <p class="updated-date">Updated on: {{ $package->updated_at->format('d F Y') }}</p>
                                        <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal"
                                            data-package="{{ $package->title }}">
                                            Customised & Send Enquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </section>
    @endif

    <!-- Adventure Packages Section -->
    @if($adventurePackages->count() > 0)
        <section id="Kashmiradventure" class="section-pad pt-0">
            <div class="container">
                <div class="section-header text-center">
                    <h3>Kashmir Adventure Packages</h3>
                </div>
                <div class="swiper-container destination-slider">
                    <div class="swiper-wrapper">
                        @foreach($adventurePackages as $package)
                            <div class="swiper-slide">
                                <div class="pricing-box">
                                    <div class="pricing-img">
                                        <img src="{{ asset($package->image) }}" alt="{{ $package->title }}">
                                    </div>
                                    <div class="pricing-content">
                                        <span class="package-time">
                                            <i class="fa-regular fa-calendar"></i> {{ $package->duration_days }} Days /
                                            {{ $package->duration_nights }} Night
                                        </span>
                                        <h4>{{ $package->title }}</h4>
                                        <div class="features">
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/1.png') }}" alt="">
                                                <p>{{ $package->flights ?? 0 }} Flights</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/2.png') }}" alt="">
                                                <p>{{ $package->hotels ?? 0 }} Hotels</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/3.png') }}" alt="">
                                                <p>{{ $package->activities ?? 0 }} Activities</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/4.png') }}" alt="">
                                                <p>{{ $package->transfers ?? 0 }} Transfers</p>
                                            </div>
                                        </div>
                                        @if($package->inclusions)
                                            <div class="package-includes">
                                                <ul>
                                                    @foreach(explode(',', $package->inclusions) as $inclusion)
                                                        <li><span>{{ trim($inclusion) }}</span></li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        @if($package->highlights)
                                            <div class="others-feature">
                                                <ul>
                                                    @foreach(explode(',', $package->highlights) as $highlight)
                                                        <li>{{ trim($highlight) }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        <h3>₹{{ number_format($package->price) }} <sup>Per person</sup></h3>
                                        @if($package->original_price)
                                            <h5><del>₹{{ number_format($package->original_price) }}</del>
                                                <span>{{ round((($package->original_price - $package->price) / $package->original_price) * 100) }}%
                                                    OFF</span>
                                            </h5>
                                        @endif
                                        <p class="updated-date">Updated on: {{ $package->updated_at->format('d F Y') }}</p>
                                        <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal"
                                            data-package="{{ $package->title }}">
                                            Customised & Send Enquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </section>
    @endif

    <!-- Destinations Section -->
    <section id="Destinations" class="section-pad destination-sec">
        <div class="container">
            <div class="section-header text-center">
                <h3>Destinations that define Kashmir's charm</h3>
                <p>Let Kashmir weave its magic around you as you traverse its iconic destinations. They pave the way to
                    experiences that turn your travel dreams into reality.</p>
            </div>
            <div class="grid-row-box">
                @foreach($destinations as $index => $destination)
                    <a href="#" class="destin-bx item-{{ ($index % 5) + 1 }} dest-bx-{{ $index == 1 ? '80' : '40' }}">
                        <img src="{{ asset($destination->image) }}" alt="{{ $destination->name }}">
                        <div class="destin-bx-overlay"></div>
                        <div class="destin-content">
                            <h4>{{ $destination->name }}</h4>
                            <p>{{ $destination->duration }}</p>
                        </div>
                    </a>
                @endforeach
            </div>
        </div>
    </section>

    <!-- Cultural Packages Section -->
    @if($culturalPackages->count() > 0)
        <section id="Cultural" class="section-pad">
            <div class="container">
                <div class="section-header text-center">
                    <h3>Kashmir Cultural Packages</h3>
                </div>
                <div class="swiper-container destination-slider">
                    <div class="swiper-wrapper">
                        @foreach($culturalPackages as $package)
                            <div class="swiper-slide">
                                <div class="pricing-box">
                                    <div class="pricing-img">
                                        <img src="{{ asset($package->image) }}" alt="{{ $package->title }}">
                                    </div>
                                    <div class="pricing-content">
                                        <span class="package-time">
                                            <i class="fa-regular fa-calendar"></i> {{ $package->duration_days }} Days /
                                            {{ $package->duration_nights }} Night
                                        </span>
                                        <h4>{{ $package->title }}</h4>
                                        <div class="features">
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/1.png') }}" alt="">
                                                <p>{{ $package->flights ?? 0 }} Flights</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/2.png') }}" alt="">
                                                <p>{{ $package->hotels ?? 0 }} Hotels</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/3.png') }}" alt="">
                                                <p>{{ $package->activities ?? 0 }} Activities</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="{{ asset('images/feature-icon/4.png') }}" alt="">
                                                <p>{{ $package->transfers ?? 0 }} Transfers</p>
                                            </div>
                                        </div>
                                        @if($package->inclusions)
                                            <div class="package-includes">
                                                <ul>
                                                    @foreach(explode(',', $package->inclusions) as $inclusion)
                                                        <li><span>{{ trim($inclusion) }}</span></li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        @if($package->highlights)
                                            <div class="others-feature">
                                                <ul>
                                                    @foreach(explode(',', $package->highlights) as $highlight)
                                                        <li>{{ trim($highlight) }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        <h3>₹{{ number_format($package->price) }} <sup>Per person</sup></h3>
                                        @if($package->original_price)
                                            <h5><del>₹{{ number_format($package->original_price) }}</del>
                                                <span>{{ round((($package->original_price - $package->price) / $package->original_price) * 100) }}%
                                                    OFF</span>
                                            </h5>
                                        @endif
                                        <p class="updated-date">Updated on: {{ $package->updated_at->format('d F Y') }}</p>
                                        <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal"
                                            data-package="{{ $package->title }}">
                                            Customised & Send Enquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </section>
    @endif

    <section id="faq" class="section-pad faq-sec">
        <div class="container">
            <div class="section-header text-center">
                <h3>Frequently Asked Questions</h3>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="accordion" id="accordionExample">
                        @foreach($faqs as $index => $faq)
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="heading{{ $index }}">
                                    <button class="accordion-button {{ $index > 0 ? 'collapsed' : '' }}" type="button"
                                        data-bs-toggle="collapse" data-bs-target="#collapse{{ $index }}"
                                        aria-expanded="{{ $index == 0 ? 'true' : 'false' }}">
                                        Q: {{ $faq->question }}
                                    </button>
                                </h2>
                                <div id="collapse{{ $index }}"
                                    class="accordion-collapse collapse {{ $index == 0 ? 'show' : '' }}"
                                    aria-labelledby="heading{{ $index }}" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">{!! $faq->answer !!}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="section-pad">
        <div class="container">
            <div class="section-header text-center">
                <h3>Why Choose Us</h3>
            </div>
            <div class="row">
                @foreach($whyChooseUs as $item)
                    <div class="col-lg-3 col-md-6">
                        <div class="why-us-bx">
                            @if($item->image)
                                <img src="{{ asset($item->image) }}" alt="{{ $item->title }}">
                            @endif
                            <h4>{{ $item->title }}</h4>
                            <p>{{ $item->description }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <section class="section-pad">

    </section>
    <footer id="contact" class="footer">
        <div class="footer-top">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-12 text-lg-center">
                        <div class="footer-content">
                            <img src="{{ asset($footer->logo ?? 'images/flydivinetreasurekashlogo.png') }}" alt="logo">
                            <p>{{ $footer->tagline ?? 'Your Gateway to Breathtaking Adventures in the Heart of Kashmir!' }}
                            </p>
                        </div>
                        <div class="footer-link social-link">
                            <h4>Follow Us</h4>
                            <ul>
                                @if($footer->facebook_url)
                                    <li><a href="{{ $footer->facebook_url }}" target="_blank"><i
                                                class="fa-brands fa-facebook-f"></i></a></li>
                                @endif
                                @if($footer->instagram_url)
                                    <li><a href="{{ $footer->instagram_url }}" target="_blank"><i
                                                class="fa-brands fa-instagram"></i></a></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="gradient-hr"></div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Quick Links</h4>
                            <ul>
                                <li><a href="#">Home</a></li>
                                <li><a href="#Packages">Tour Packages</a></li>
                                <li><a href="#Destinations">Destinations</a></li>
                                <li><a href="#faq">FAQ</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Support</h4>
                            <ul>
                                <li><a href="{{ route('static.page', 'cancellation-refunds') }}">Cancellation &
                                        Refunds</a></li>
                                <li><a href="{{ route('static.page', 'privacy-policy') }}">Privacy Policy</a></li>
                                <li><a href="{{ route('static.page', 'terms-conditions') }}">Terms & Conditions</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Contact Info</h4>
                            <ul>
                                @if($footer->email)
                                    <li><a href="mailto:{{ $footer->email }}"><i class="fa-solid fa-envelope"></i>
                                            {{ $footer->email }}</a></li>
                                @endif
                                @if($footer->phone)
                                    <li><a href="tel:{{ $footer->phone }}"><i class="fa-solid fa-phone"></i>
                                            {{ $footer->phone }}</a></li>
                                @endif
                                @if($footer->address)
                                    <li><a href="#"><i class="fa-solid fa-location-dot"></i> {{ $footer->address }}</a></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Gallery</h4>
                            <div class="footer-images">
                                @if($footer->gallery_images && is_array($footer->gallery_images))
                                    @foreach($footer->gallery_images as $image)
                                        <img src="{{ asset($image) }}" alt="Gallery">
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <p class="text-center text-light">&copy; {{ date('Y') }} slipinholidays. All Rights Reserved.
                    Developed By <a href="https://elyspace.com/web-design" class="text-light">ElySpace</a></p>
            </div>
        </div>
    </footer>

    <!-- Button trigger modal -->

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-end">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="booking-form p-0">
                        <div class="package-info">
                            <div class="package-info-content">
                                <h4>Talk to Expert</h4>
                            </div>
                        </div>
                        <form action="{{ route('enquiry.store') }}" method="POST" id="modalForm">
                            @csrf
                            <input type="hidden" name="package_name" id="package_name">
                            <div class="form-group">
                                <input type="text" name="name" class="form-control" placeholder="Your Name" required
                                    pattern="[A-Za-z\s]+" title="Please enter only letters and spaces">
                            </div>
                            <div class="form-group">
                                <input type="tel" name="mobile" class="form-control"
                                    placeholder="Enter 10 digit mobile number" required pattern="[0-9]{10}"
                                    maxlength="10" minlength="10" title="Please enter exactly 10 digit mobile number"
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                            </div>
                            <div class="form-group">
                                <input type="email" name="email" class="form-control" placeholder="Email Id" required
                                    title="Please enter a valid email address with @">
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input type="number" name="persons" class="form-control"
                                            placeholder="Number Of Person" required min="1"
                                            title="Please enter at least 1 person"
                                            oninput="if(this.value < 1) this.value = 1">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input type="date" name="booking_date" class="form-control booking-date"
                                            placeholder="Booking Date" required title="Please select a future date">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <textarea name="message" class="form-control" placeholder="Message"></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary btn-main">Connect with an Expert</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    @if($footer->whatsapp_number)
        <a href="https://wa.me/{{ $footer->whatsapp_number }}" target="_blank" class="whatsapp-icon">
            <img src="images/whatsappiconlandingpage.png" alt="whatsapp"> </a>
    @endif
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="assets/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/swiper/js/swiper.min.js"></script>
    <script src="js/main.js"></script>

    <script>
        const slidesContainer = document.querySelector('.testinomials-box');
        const prevBtn = document.querySelector('.prev-btn');
        const nextBtn = document.querySelector('.next-btn');
        let currentSlide = 0;
        const totalSlides = document.querySelectorAll('.testmonial-box').length;

        function updateSlidePosition() {
            slidesContainer.style.transform = `translateX(-${currentSlide * 100}%)`;
        }

        prevBtn.addEventListener('click', () => {
            currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
            updateSlidePosition();
        });

        nextBtn.addEventListener('click', () => {
            currentSlide = (currentSlide + 1) % totalSlides;
            updateSlidePosition();
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const enquiryButtons = document.querySelectorAll(".open-enquiry-form");
            enquiryButtons.forEach(button => {
                button.addEventListener("click", function () {
                    let packageName = this.getAttribute("data-package");
                    document.getElementById("package_name").value = packageName;
                });
            });

            // Set minimum date to today for all date inputs
            const today = new Date().toISOString().split('T')[0];
            const dateInputs = document.querySelectorAll('.booking-date');
            dateInputs.forEach(input => {
                input.setAttribute('min', today);
            });
        });
    </script>


    <script>
        const hideElfsightBadge = () => {
            const badges = document.querySelectorAll('a[href*="elfsight.com/google-reviews-widget"]');
            badges.forEach(badge => {
                if (badge.textContent.includes("Free Google Reviews widget")) {
                    badge.style.display = "none";
                }
            });
        };

        // Run initially and keep checking in case it's re-added
        const observer = new MutationObserver(hideElfsightBadge);
        observer.observe(document.body, { childList: true, subtree: true });

        // Initial run
        hideElfsightBadge();
    </script>


    <script>
        document.addEventListener("DOMContentLoaded", function () {
            setTimeout(function () {
                var myModal = new bootstrap.Modal(document.getElementById('exampleModal'), {
                    backdrop: 'static', // keeps background click from closing
                    keyboard: true
                });
                myModal.show();
            }, 1000); // 3 seconds delay
        });
    </script>

</body>

</html>