<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="UTF-8">

    <!-- Meta Title -->
    <title>{{ $page->meta_title ?? $page->title }}</title>

    <!-- Meta Description -->
    <meta name="description"
        content="{{ $page->meta_description ?? 'Learn more about our policies and terms at flydivinetreasure.' }}">

    <!-- Meta Keywords (Optional but included for reference) -->
    <meta name="keywords"
        content="Kashmir tour packages, Kashmir travel guide, best places to visit in Kashmir, Dal Lake houseboats, Gulmarg skiing, Pahalgam tours, Srinagar sightseeing, Kashmir tourism, Kashmir holiday packages, Sonmarg trekking, Kashmir honeymoon, affordable Kashmir trips">

    <!-- Other Important Meta Tags -->
    <meta name="author" content="flydivinetreasure">
    <meta name="robots" content="index, follow">
    <link rel="icon" type="image/png" href="/images/flydivinetreasurekashlogo.png">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="../assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/swiper/css/swiper.css">
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/responsive.css">
    <meta name="facebook-domain-verification" content="nrt8ku11aokj5vdm95cyi8h7z1lva1" />

    {{-- Dynamic Primary Color --}}
    @php $primaryColor = $seoSettings->primary_color ?? '#008746'; @endphp
    <style>
        :root {
            --primary-color:
                {{ $primaryColor }}
            ;
        }

        .section-pad h1 {
            color:
                {{ $primaryColor }}
            ;
        }

        .section-pad h1::after {
            background:
                {{ $primaryColor }}
            ;
        }

        .content-area strong {
            color:
                {{ $primaryColor }}
            ;
        }

        .content-area a {
            color:
                {{ $primaryColor }}
            ;
        }

        .content-area a:hover {
            border-bottom-color:
                {{ $primaryColor }}
            ;
        }

        .btn-primary {
            background-color:
                {{ $primaryColor }}
                !important;
            border-color:
                {{ $primaryColor }}
                !important;
        }
    </style>
</head>


<body>
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-P7LR2K6D" height="0" width="0"
            style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->

    <header class="header">
        <div class="header-bottom">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-2 col-5 order-lg-1">
                        <div class="header-logo">
                            <a href="{{ url('/') }}">
                                <img src="{{ asset($footer->logo ?? 'images/flydivinetreasurekashlogo.png') }}"
                                    alt="logo">
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-7 order-lg-3">
                        <div class="header-right-tabs text-end">
                            <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                <li class="nav-item text-left" role="presentation">
                                    <a href="tel:{{ $footer->phone ?? '+918899269767' }}"
                                        class="nav-link active text-center">Call Us</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a href="javascript:void(0)" class="nav-link" data-bs-toggle="modal"
                                        data-bs-target="#exampleModal">Book Now</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-7 order-lg-2">
                        <div class="header-nav">
                            <div class="swiper-container mySwiper">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="{{ url('/') }}#bestpackage">
                                                <img src="{{ asset('images/kashmir-header-icon.png') }}" width="32px">
                                                <p>Best Kashmir</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="{{ url('/') }}#Honeymoonpackage">
                                                <img src="{{ asset('images/honeymoon-headericon.png') }}" width="32px">
                                                <p>Honeymoon</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="{{ url('/') }}#Kashmiradventure">
                                                <img src="{{ asset('images/advantureheadericon.png') }}" width="32px">
                                                <p>Adventure</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="{{ url('/') }}#Cultural">
                                                <img src="{{ asset('images/culturalheadericon.png') }}" width="32px">
                                                <p>Cultural</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="{{ url('/') }}#Destinations">
                                                <img src="{{ asset('images/destinationheadericon.png') }}" width="32px">
                                                <p>Destinations</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="{{ url('/') }}#faq">
                                                <img src="{{ asset('images/faqheadericon.png') }}" width="32px">
                                                <p>FAQ</p>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <section class="section-pad" style="min-height: 60vh;">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <h1 class="mb-4">{{ $page->title }}</h1>
                    <div class="content-area">
                        {!! $page->content !!}
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer id="contact" class="footer">
        <div class="footer-top">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-12 text-lg-center">
                        <div class="footer-content">
                            <img src="{{ asset($footer->logo ?? 'images/flydivinetreasurekashlogo.png') }}" alt="logo">
                            <p>{{ $footer->tagline ?? 'Your Gateway to Breathtaking Adventures in the Heart of Kashmir!' }}
                            </p>
                        </div>
                        <div class="footer-link social-link">
                            <h4>Follow Us</h4>
                            <ul>
                                @if($footer->facebook_url)
                                    <li><a href="{{ $footer->facebook_url }}" target="_blank"><i
                                                class="fa-brands fa-facebook-f"></i></a></li>
                                @endif
                                @if($footer->instagram_url)
                                    <li><a href="{{ $footer->instagram_url }}" target="_blank"><i
                                                class="fa-brands fa-instagram"></i></a></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="gradient-hr"></div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Quick Links</h4>
                            <ul>
                                <li><a href="{{ url('/') }}">Home</a></li>
                                <li><a href="{{ url('/') }}#Packages">Tour Packages</a></li>
                                <li><a href="{{ url('/') }}#Destinations">Destinations</a></li>
                                <li><a href="{{ url('/') }}#faq">FAQ</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Support</h4>
                            <ul>
                                <li><a href="{{ route('static.page', 'cancellation-refunds') }}">Cancellation &
                                        Refunds</a></li>
                                <li><a href="{{ route('static.page', 'privacy-policy') }}">Privacy Policy</a></li>
                                <li><a href="{{ route('static.page', 'terms-conditions') }}">Terms & Conditions</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Contact Info</h4>
                            <ul>
                                @if($footer->email)
                                    <li><a href="mailto:{{ $footer->email }}"><i class="fa-solid fa-envelope"></i>
                                            {{ $footer->email }}</a></li>
                                @endif
                                @if($footer->phone)
                                    <li><a href="tel:{{ $footer->phone }}"><i class="fa-solid fa-phone"></i>
                                            {{ $footer->phone }}</a></li>
                                @endif
                                @if($footer->address)
                                    <li><a href="#"><i class="fa-solid fa-location-dot"></i> {{ $footer->address }}</a></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Gallery</h4>
                            <div class="footer-images">
                                @if($footer->gallery_images && is_array($footer->gallery_images))
                                    @foreach($footer->gallery_images as $image)
                                        <img src="{{ asset($image) }}" alt="Gallery">
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <p class="text-center text-light">&copy; {{ date('Y') }} slipinholidays. All Rights Reserved.
                    Developed By <a href="https://elyspace.com/web-design" class="text-light">ElySpace</a></p>
            </div>
        </div>
    </footer>
    <style>
        /* Container & Section Spacing */
        .section-pad {
            padding: 80px 0;
            background-color: #fff;
            color: #333;
            /* Darker text for readability on white */
        }

        /* Page Title Styling */
        .section-pad h1 {
            font-size: 3rem;
            font-weight: 800;
            color: #008746;
            margin-bottom: 40px;
            letter-spacing: -1px;
            position: relative;
        }

        /* Subtle Accent Line under Title */
        .section-pad h1::after {
            content: '';
            display: block;
            width: 60px;
            height: 4px;
            background: #008746;
            margin-top: 15px;
            border-radius: 2px;
        }

        /* Styling Dynamic Content Area */
        .content-area {
            line-height: 1.8;
            font-size: 1.1rem;
            color: #4a4a4a;
        }

        /* Internal Dynamic Elements */
        .content-area p {
            margin-bottom: 1.5rem;
        }

        .content-area h2,
        .content-area h3 {
            color: #2d2d2d;
            margin-top: 2.5rem;
            margin-bottom: 1rem;
            font-weight: 700;
        }

        .content-area strong {
            color: #008746;
            /* Highlights bold text with your primary color */
        }

        .content-area a {
            color: #008746;
            text-decoration: none;
            border-bottom: 2px solid rgba(237, 136, 59, 0.2);
            transition: all 0.3s ease;
        }

        .content-area a:hover {
            border-bottom-color: #008746;
            background: rgba(237, 136, 59, 0.05);
        }

        .content-area ul,
        .content-area ol {
            margin-bottom: 1.5rem;
            padding-left: 1.2rem;
        }

        .content-area li {
            margin-bottom: 0.5rem;
        }

        /* Modern Card-like feel for the column (Optional) */
        .col-lg-10 {
            background: #fff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
            /* Very soft shadow */
        }
    </style>

    @if($footer->whatsapp_number)
        <a href="https://wa.me/{{ $footer->whatsapp_number }}" target="_blank" class="whatsapp-icon">
            <img src="../images/whatsappiconlandingpage.png" alt="whatsapp"> </a>
    @endif
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="../assets/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/swiper/js/swiper.min.js"></script>
    <script src="../js/main.js"></script>
    <script src="{{ asset('assets/bootstrap/bootstrap.bundle.min.js') }}"></script>
</body>

</html>