<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\DestinationController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\WhyChooseUsController;
use App\Http\Controllers\Admin\StaticPageController;
use App\Http\Controllers\Admin\EnquiryController;
use App\Http\Controllers\Admin\FooterController;
use App\Http\Controllers\Admin\TrackingCodeController;
use App\Http\Controllers\Admin\SeoSettingController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\EnquiryController as FrontendEnquiryController;

/*
|--------------------------------------------------------------------------
| Frontend Routes
|--------------------------------------------------------------------------
*/
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/newpage', [HomeController::class, 'newpage'])->name('newpage');
Route::post('/enquiry', [FrontendEnquiryController::class, 'store'])->name('enquiry.store');
Route::get('/thanks', [FrontendEnquiryController::class, 'thanks'])->name('thanks');
Route::get('/page/{slug}', [HomeController::class, 'staticPage'])->name('static.page');

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
*/
Route::prefix('admin')->name('admin.')->group(function () {
    // Auth routes
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');
    Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

    // Protected routes
    Route::middleware(\App\Http\Middleware\AdminAuth::class)->group(function () {
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

        Route::resource('packages', PackageController::class)->except(['show']);
        Route::resource('banners', BannerController::class)->except(['show']);
        Route::resource('destinations', DestinationController::class)->except(['show']);
        Route::resource('faqs', FaqController::class)->except(['show']);
        Route::resource('why-choose-us', WhyChooseUsController::class)->except(['show']);
        Route::resource('static-pages', StaticPageController::class)->only(['index', 'edit', 'update']);

        Route::get('enquiries', [EnquiryController::class, 'index'])->name('enquiries.index');
        Route::get('enquiries/{enquiry}', [EnquiryController::class, 'show'])->name('enquiries.show');
        Route::delete('enquiries/{enquiry}', [EnquiryController::class, 'destroy'])->name('enquiries.destroy');
        Route::post('enquiries/{enquiry}/mark-read', [EnquiryController::class, 'markAsRead'])->name('enquiries.mark-read');

        Route::get('footer', [FooterController::class, 'edit'])->name('footer.edit');
        Route::put('footer', [FooterController::class, 'update'])->name('footer.update');

        Route::get('tracking-codes', [TrackingCodeController::class, 'edit'])->name('tracking-codes.edit');
        Route::put('tracking-codes', [TrackingCodeController::class, 'update'])->name('tracking-codes.update');

        Route::get('seo-settings', [SeoSettingController::class, 'edit'])->name('seo-settings.edit');
        Route::put('seo-settings', [SeoSettingController::class, 'update'])->name('seo-settings.update');

        Route::get('profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::put('profile', [ProfileController::class, 'update'])->name('profile.update');
    });
});
