
<?php $__env->startSection('title', 'Edit Destination'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">Edit: <?php echo e($destination->name); ?></div>
        <div class="card-body">
            <form action="<?php echo e(route('admin.destinations.update', $destination)); ?>" method="POST"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3"><label class="form-label">Name *</label><input type="text" name="name"
                                class="form-control" value="<?php echo e(old('name', $destination->name)); ?>" required></div>
                        <div class="mb-3"><label class="form-label">Duration</label><input type="text" name="duration"
                                class="form-control" value="<?php echo e(old('duration', $destination->duration)); ?>"></div>
                        <div class="mb-3"><label class="form-label">Description</label><textarea name="description"
                                class="form-control" rows="3"><?php echo e(old('description', $destination->description)); ?></textarea>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3"><label class="form-label">Image</label><?php if($destination->image): ?>
                            <div class="mb-2"><img src="<?php echo e(asset($destination->image)); ?>" alt="" class="img-thumbnail"
                        style="max-width: 150px;"></div><?php endif; ?><input type="file" name="image"
                                class="form-control" accept="image/*">
                        </div>
                        <div class="mb-3"><label class="form-label">Sort Order</label><input type="number" name="sort_order"
                                class="form-control" value="<?php echo e(old('sort_order', $destination->sort_order)); ?>"></div>
                        <div class="mb-3">
                            <div class="form-check"><input type="checkbox" name="is_active" class="form-check-input"
                                    value="1" <?php echo e($destination->is_active ? 'checked' : ''); ?>><label
                                    class="form-check-label">Active</label></div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update</button>
                <a href="<?php echo e(route('admin.destinations.index')); ?>" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/destinations/edit.blade.php ENDPATH**/ ?>