<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="UTF-8">

    <!-- Meta Title -->
    <title>
        <?php echo e($seoSettings->meta_title ?? 'Best Kashmir Tour Packages | Explore Paradise on Earth | flydivinetreasure'); ?>

    </title>

    <!-- Meta Description -->
    <meta name="description"
        content="<?php echo e($seoSettings->meta_description ?? 'Explore Kashmir with flydivinetreasure\'s affordable tour packages. Stay in Dal Lake houseboats, enjoy skiing in Gulmarg, and experience Pahalgam adventures. Book your Kashmir trip today!'); ?>">

    <!-- Meta Keywords (Optional but included for reference) -->
    <meta name="keywords"
        content="<?php echo e($seoSettings->meta_keywords ?? 'Kashmir tour packages, Kashmir travel guide, best places to visit in Kashmir, Dal Lake houseboats, Gulmarg skiing, Pahalgam tours, Srinagar sightseeing, Kashmir tourism, Kashmir holiday packages, Sonmarg trekking, Kashmir honeymoon, affordable Kashmir trips'); ?>">

    <!-- Other Important Meta Tags -->
    <meta name="author" content="<?php echo e($seoSettings->meta_author ?? 'flydivinetreasure'); ?>">
    <meta name="robots" content="index, follow">
    <link rel="icon" type="image/png" href="/images/flydivinetreasurekashlogo.png">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/swiper/css/swiper.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
    <meta name="facebook-domain-verification" content="nrt8ku11aokj5vdm95cyi8h7z1lva1" />

    
    <?php 
        $primaryColor = $seoSettings->primary_color ?? '#008746';
        $packageTimeBg = $seoSettings->package_time_bg ?? '#008746';
        $packageTimeText = $seoSettings->package_time_text ?? '#ffffff';
        $packageIncludesBg = $seoSettings->package_includes_bg ?? '#008746';
        $packageIncludesText = $seoSettings->package_includes_text ?? '#ffffff';
        $destinationSecBg = $seoSettings->destination_sec_bg ?? '#fff5f9';
    ?>
    <style>
        :root {
            --primary-color: <?php echo e($primaryColor); ?>;
        }
        .header-right-tabs .nav-link { color: <?php echo e($primaryColor); ?>; }
        .header-right-tabs .nav-link.active { background-color: <?php echo e($primaryColor); ?> !important; color: #fff !important; }
        .package-box .table td i { color: <?php echo e($primaryColor); ?>; }
        .package-time { background-color: <?php echo e($packageTimeBg); ?>; color: <?php echo e($packageTimeText); ?>; }
        .package-includes ul li span { background-color: <?php echo e($packageIncludesBg); ?>; color: <?php echo e($packageIncludesText); ?>; }
        .pricing-content .btn:hover { color: <?php echo e($primaryColor); ?>; }
        .about-content h4 { color: <?php echo e($primaryColor); ?>; }
        .quote-text::before { background-color: <?php echo e($primaryColor); ?>; }
        .about-lists ul li i { color: <?php echo e($primaryColor); ?>; }
        .overview-section .accordion-button i { color: <?php echo e($primaryColor); ?>; }
        .btn-primary { background-color: <?php echo e($primaryColor); ?> !important; border-color: <?php echo e($primaryColor); ?> !important; }
        .btn-primary:hover { background-color: transparent !important; color: <?php echo e($primaryColor); ?> !important; border-color: <?php echo e($primaryColor); ?> !important; }
        .destination-sec { background-color: <?php echo e($destinationSecBg); ?> !important; }
    </style>

    
    <?php if($trackingCodes->google_tag_manager_id): ?>
        <script>(function (w, d, s, l, i) {
                w[l] = w[l] || []; w[l].push({
                    'gtm.start':
                        new Date().getTime(), event: 'gtm.js'
                }); var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : ''; j.async = true; j.src =
                        'https://www.googletagmanager.com/gtm.js?id=' + i + dl; f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '<?php echo e($trackingCodes->google_tag_manager_id); ?>');</script>
    <?php endif; ?>

    
    <?php if($trackingCodes->google_analytics_id): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($trackingCodes->google_analytics_id); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() { dataLayer.push(arguments); }
            gtag('js', new Date());
            gtag('config', '<?php echo e($trackingCodes->google_analytics_id); ?>');
        </script>
    <?php endif; ?>

    
    <?php if($trackingCodes->facebook_pixel_id): ?>
        <script>
            !function (f, b, e, v, n, t, s) {
                if (f.fbq) return; n = f.fbq = function () {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n; n.push = n; n.loaded = !0; n.version = '2.0';
                n.queue = []; t = b.createElement(e); t.async = !0;
                t.src = v; s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($trackingCodes->facebook_pixel_id); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=<?php echo e($trackingCodes->facebook_pixel_id); ?>&ev=PageView&noscript=1" /></noscript>
    <?php endif; ?>

    
    <?php if($trackingCodes->custom_head_scripts): ?>
        <?php echo $trackingCodes->custom_head_scripts; ?>

    <?php endif; ?>
</head>

<body>
    
    <?php if($trackingCodes->google_tag_manager_id): ?>
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo e($trackingCodes->google_tag_manager_id); ?>"
                height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <?php endif; ?>

    <header class="header">
        <div class="header-bottom">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-2 col-5 order-lg-1">
                        <div class="header-logo">
                            <a href="<?php echo e(url('/')); ?>">
                                <img src="<?php echo e(asset($footer->logo ?? 'images/flydivinetreasurekashlogo.png')); ?>"
                                    alt="logo">
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-7 order-lg-3">
                        <div class="header-right-tabs text-end">
                            <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                <li class="nav-item text-left" role="presentation">
                                    <a href="tel:<?php echo e($footer->phone ?? '+918899269767'); ?>"
                                        class="nav-link active text-center">Call Us</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a href="javascript:void(0)" class="nav-link" data-bs-toggle="modal"
                                        data-bs-target="#exampleModal">Book Now</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-7 order-lg-2">
                        <div class="header-nav">
                            <div class="swiper-container mySwiper">
                                <div class="swiper-wrapper">
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#bestpackage">
                                                <img src="<?php echo e(asset('images/kashmir-header-icon.png')); ?>" width="32px">
                                                <p>Best Kashmir</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#Honeymoonpackage">
                                                <img src="<?php echo e(asset('images/honeymoon-headericon.png')); ?>" width="32px">
                                                <p>Honeymoon</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#Kashmiradventure">
                                                <img src="<?php echo e(asset('images/advantureheadericon.png')); ?>" width="32px">
                                                <p>Adventure</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#Cultural">
                                                <img src="<?php echo e(asset('images/culturalheadericon.png')); ?>" width="32px">
                                                <p>Cultural</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#Destinations">
                                                <img src="<?php echo e(asset('images/destinationheadericon.png')); ?>" width="32px">
                                                <p>Destinations</p>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide">
                                        <div class="location-bx">
                                            <a href="#faq">
                                                <img src="<?php echo e(asset('images/faqheadericon.png')); ?>" width="32px">
                                                <p>FAQ</p>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Banner Section -->
    <section class="landing-banner-sec">
        <div class="swiper-container banner-slider">
            <div class="swiper-wrapper">
                <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide">
                        <div class="banner-content bg-cover" style="background-image: url('<?php echo e(asset($banner->image)); ?>');">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="banner-content-area">
                                            <h2><?php echo e($banner->title); ?></h2>
                                            <h4><?php echo $banner->subtitle; ?></h4>
                                            <div class="gradient-hr"></div>
                                            <h3>INR <?php echo e(number_format($banner->price)); ?>

                                                <?php if($banner->original_price): ?>
                                                    <del>INR <?php echo e(number_format($banner->original_price)); ?></del>
                                                <?php endif; ?>
                                            </h3>
                                            <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                                data-bs-toggle="modal" data-bs-target="#exampleModal"
                                                data-package="<?php echo e($banner->title); ?>">
                                                <?php echo e($banner->cta_text ?? 'Chat With Expert'); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>

        <!-- Booking Form -->
        <div class="banner-form">
            <div class="container">
                <div class="row align-items-center justify-content-between">
                    <div class="col-lg-6"></div>
                    <div class="col-lg-4">
                        <div class="booking-form">
                            <form action="<?php echo e(route('enquiry.store')); ?>" method="POST" id="bannerForm">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label>Your Name</label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter full name"
                                        required pattern="[A-Za-z\s]+" title="Please enter only letters and spaces">
                                </div>
                                <div class="form-group">
                                    <label>Your Mobile Number</label>
                                    <input type="tel" name="mobile" class="form-control"
                                        placeholder="Enter 10 digit mobile number" required pattern="[0-9]{10}"
                                        maxlength="10" minlength="10"
                                        title="Please enter exactly 10 digit mobile number"
                                        oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                </div>
                                <div class="form-group">
                                    <label>Your Email Id</label>
                                    <input type="email" name="email" class="form-control" placeholder="Enter email id"
                                        required title="Please enter a valid email address with @">
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Number of Person</label>
                                            <input type="number" name="persons" class="form-control"
                                                placeholder="Enter number of person" min="1" required
                                                title="Please enter at least 1 person"
                                                oninput="if(this.value < 1) this.value = 1">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>Booking Date</label>
                                            <input type="date" name="booking_date" class="form-control booking-date"
                                                required title="Please select a future date">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Message</label>
                                    <textarea name="message" class="form-control" rows="4"
                                        placeholder="Enter your message"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary btn-main">Book Your Tour</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Packages Table Section -->
    <section id="Packages" class="section-pad">
        <div class="container">
            <div class="section-header text-center">
                <h3>Kashmir Tour Packages</h3>
            </div>
            <div class="row">
                <?php if($bestKashmirPackages->count() > 0 || $honeymoonPackages->count() > 0): ?>
                    <div class="col-lg-6">
                        <div class="package-box">
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <tr>
                                        <th>Package Name</th>
                                        <th>Nights</th>
                                        <th>Price (₹)</th>
                                        <th></th>
                                    </tr>
                                    <?php $__currentLoopData = $bestKashmirPackages->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><i class="fa-solid fa-plane-departure"></i> <?php echo e($package->title); ?></td>
                                            <td><i class="fa-solid fa-hotel"></i> <?php echo e($package->duration_nights); ?> Nights</td>
                                            <td>Rs. <?php echo e(number_format($package->price)); ?></td>
                                            <td>
                                                <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                                    data-bs-toggle="modal" data-bs-target="#exampleModal"
                                                    data-package="<?php echo e($package->title); ?>">Book Now</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="package-box">
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <tr>
                                        <th>Package Name</th>
                                        <th>Nights</th>
                                        <th>Price (₹)</th>
                                        <th></th>
                                    </tr>
                                    <?php $__currentLoopData = $honeymoonPackages->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><i class="fa-solid fa-plane-departure"></i> <?php echo e($package->title); ?></td>
                                            <td><i class="fa-solid fa-hotel"></i> <?php echo e($package->duration_nights); ?> Nights</td>
                                            <td>Rs. <?php echo e(number_format($package->price)); ?></td>
                                            <td>
                                                <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                                    data-bs-toggle="modal" data-bs-target="#exampleModal"
                                                    data-package="<?php echo e($package->title); ?>">Book Now</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Best Kashmir Packages Section -->
    <?php if($bestKashmirPackages->count() > 0): ?>
        <section id="bestpackage" class="section-pad pt-0">
            <div class="container">
                <div class="section-header text-center">
                    <h3>Best Kashmir Packages</h3>
                </div>
                <div class="swiper-container destination-slider">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $bestKashmirPackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="pricing-box">
                                    <div class="pricing-img">
                                        <img src="<?php echo e(asset($package->image)); ?>" alt="<?php echo e($package->title); ?>">
                                    </div>
                                    <div class="pricing-content">
                                        <span class="package-time">
                                            <i class="fa-regular fa-calendar"></i> <?php echo e($package->duration_days); ?> Days /
                                            <?php echo e($package->duration_nights); ?> Night
                                        </span>
                                        <h4><?php echo e($package->title); ?></h4>
                                        <div class="features">
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/1.png')); ?>" alt="">
                                                <p><?php echo e($package->flights ?? 0); ?> Flights</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/2.png')); ?>" alt="">
                                                <p><?php echo e($package->hotels ?? 0); ?> Hotels</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/3.png')); ?>" alt="">
                                                <p><?php echo e($package->activities ?? 0); ?> Activities</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/4.png')); ?>" alt="">
                                                <p><?php echo e($package->transfers ?? 0); ?> Transfers</p>
                                            </div>
                                        </div>
                                        <?php if($package->inclusions): ?>
                                            <div class="package-includes">
                                                <ul>
                                                    <?php $__currentLoopData = explode(',', $package->inclusions); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inclusion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><span><?php echo e(trim($inclusion)); ?></span></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($package->highlights): ?>
                                            <div class="others-feature">
                                                <ul>
                                                    <?php $__currentLoopData = explode(',', $package->highlights); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $highlight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e(trim($highlight)); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <h3>₹<?php echo e(number_format($package->price)); ?> <sup>Per person</sup></h3>
                                        <?php if($package->original_price): ?>
                                            <h5><del>₹<?php echo e(number_format($package->original_price)); ?></del>
                                                <span><?php echo e(round((($package->original_price - $package->price) / $package->original_price) * 100)); ?>%
                                                    OFF</span>
                                            </h5>
                                        <?php endif; ?>
                                        <p class="updated-date">Updated on: <?php echo e($package->updated_at->format('d F Y')); ?></p>
                                        <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal"
                                            data-package="<?php echo e($package->title); ?>">
                                            Customised & Send Enquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Honeymoon Special Section -->
    <?php if($honeymoonPackages->count() > 0): ?>
        <section id="Honeymoonpackage" class="section-pad pt-0">
            <div class="container">
                <div class="section-header text-center">
                    <h3>Honeymoon Special</h3>
                </div>
                <div class="swiper-container destination-slider">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $honeymoonPackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="pricing-box">
                                    <div class="pricing-img">
                                        <img src="<?php echo e(asset($package->image)); ?>" alt="<?php echo e($package->title); ?>">
                                    </div>
                                    <div class="pricing-content">
                                        <span class="package-time">
                                            <i class="fa-regular fa-calendar"></i> <?php echo e($package->duration_days); ?> Days /
                                            <?php echo e($package->duration_nights); ?> Night
                                        </span>
                                        <h4><?php echo e($package->title); ?></h4>
                                        <div class="features">
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/1.png')); ?>" alt="">
                                                <p><?php echo e($package->flights ?? 0); ?> Flights</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/2.png')); ?>" alt="">
                                                <p><?php echo e($package->hotels ?? 0); ?> Hotels</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/3.png')); ?>" alt="">
                                                <p><?php echo e($package->activities ?? 0); ?> Activities</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/4.png')); ?>" alt="">
                                                <p><?php echo e($package->transfers ?? 0); ?> Transfers</p>
                                            </div>
                                        </div>
                                        <?php if($package->inclusions): ?>
                                            <div class="package-includes">
                                                <ul>
                                                    <?php $__currentLoopData = explode(',', $package->inclusions); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inclusion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><span><?php echo e(trim($inclusion)); ?></span></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($package->highlights): ?>
                                            <div class="others-feature">
                                                <ul>
                                                    <?php $__currentLoopData = explode(',', $package->highlights); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $highlight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e(trim($highlight)); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <h3>₹<?php echo e(number_format($package->price)); ?> <sup>Per person</sup></h3>
                                        <?php if($package->original_price): ?>
                                            <h5><del>₹<?php echo e(number_format($package->original_price)); ?></del>
                                                <span><?php echo e(round((($package->original_price - $package->price) / $package->original_price) * 100)); ?>%
                                                    OFF</span>
                                            </h5>
                                        <?php endif; ?>
                                        <p class="updated-date">Updated on: <?php echo e($package->updated_at->format('d F Y')); ?></p>
                                        <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal"
                                            data-package="<?php echo e($package->title); ?>">
                                            Customised & Send Enquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Adventure Packages Section -->
    <?php if($adventurePackages->count() > 0): ?>
        <section id="Kashmiradventure" class="section-pad pt-0">
            <div class="container">
                <div class="section-header text-center">
                    <h3>Kashmir Adventure Packages</h3>
                </div>
                <div class="swiper-container destination-slider">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $adventurePackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="pricing-box">
                                    <div class="pricing-img">
                                        <img src="<?php echo e(asset($package->image)); ?>" alt="<?php echo e($package->title); ?>">
                                    </div>
                                    <div class="pricing-content">
                                        <span class="package-time">
                                            <i class="fa-regular fa-calendar"></i> <?php echo e($package->duration_days); ?> Days /
                                            <?php echo e($package->duration_nights); ?> Night
                                        </span>
                                        <h4><?php echo e($package->title); ?></h4>
                                        <div class="features">
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/1.png')); ?>" alt="">
                                                <p><?php echo e($package->flights ?? 0); ?> Flights</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/2.png')); ?>" alt="">
                                                <p><?php echo e($package->hotels ?? 0); ?> Hotels</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/3.png')); ?>" alt="">
                                                <p><?php echo e($package->activities ?? 0); ?> Activities</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/4.png')); ?>" alt="">
                                                <p><?php echo e($package->transfers ?? 0); ?> Transfers</p>
                                            </div>
                                        </div>
                                        <?php if($package->inclusions): ?>
                                            <div class="package-includes">
                                                <ul>
                                                    <?php $__currentLoopData = explode(',', $package->inclusions); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inclusion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><span><?php echo e(trim($inclusion)); ?></span></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($package->highlights): ?>
                                            <div class="others-feature">
                                                <ul>
                                                    <?php $__currentLoopData = explode(',', $package->highlights); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $highlight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e(trim($highlight)); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <h3>₹<?php echo e(number_format($package->price)); ?> <sup>Per person</sup></h3>
                                        <?php if($package->original_price): ?>
                                            <h5><del>₹<?php echo e(number_format($package->original_price)); ?></del>
                                                <span><?php echo e(round((($package->original_price - $package->price) / $package->original_price) * 100)); ?>%
                                                    OFF</span>
                                            </h5>
                                        <?php endif; ?>
                                        <p class="updated-date">Updated on: <?php echo e($package->updated_at->format('d F Y')); ?></p>
                                        <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal"
                                            data-package="<?php echo e($package->title); ?>">
                                            Customised & Send Enquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Destinations Section -->
    <section id="Destinations" class="section-pad destination-sec">
        <div class="container">
            <div class="section-header text-center">
                <h3>Destinations that define Kashmir's charm</h3>
                <p>Let Kashmir weave its magic around you as you traverse its iconic destinations. They pave the way to
                    experiences that turn your travel dreams into reality.</p>
            </div>
            <div class="grid-row-box">
                <?php $__currentLoopData = $destinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $destination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="#" class="destin-bx item-<?php echo e(($index % 5) + 1); ?> dest-bx-<?php echo e($index == 1 ? '80' : '40'); ?>">
                        <img src="<?php echo e(asset($destination->image)); ?>" alt="<?php echo e($destination->name); ?>">
                        <div class="destin-bx-overlay"></div>
                        <div class="destin-content">
                            <h4><?php echo e($destination->name); ?></h4>
                            <p><?php echo e($destination->duration); ?></p>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- Cultural Packages Section -->
    <?php if($culturalPackages->count() > 0): ?>
        <section id="Cultural" class="section-pad">
            <div class="container">
                <div class="section-header text-center">
                    <h3>Kashmir Cultural Packages</h3>
                </div>
                <div class="swiper-container destination-slider">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $culturalPackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="pricing-box">
                                    <div class="pricing-img">
                                        <img src="<?php echo e(asset($package->image)); ?>" alt="<?php echo e($package->title); ?>">
                                    </div>
                                    <div class="pricing-content">
                                        <span class="package-time">
                                            <i class="fa-regular fa-calendar"></i> <?php echo e($package->duration_days); ?> Days /
                                            <?php echo e($package->duration_nights); ?> Night
                                        </span>
                                        <h4><?php echo e($package->title); ?></h4>
                                        <div class="features">
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/1.png')); ?>" alt="">
                                                <p><?php echo e($package->flights ?? 0); ?> Flights</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/2.png')); ?>" alt="">
                                                <p><?php echo e($package->hotels ?? 0); ?> Hotels</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/3.png')); ?>" alt="">
                                                <p><?php echo e($package->activities ?? 0); ?> Activities</p>
                                            </div>
                                            <div class="feature-box">
                                                <img src="<?php echo e(asset('images/feature-icon/4.png')); ?>" alt="">
                                                <p><?php echo e($package->transfers ?? 0); ?> Transfers</p>
                                            </div>
                                        </div>
                                        <?php if($package->inclusions): ?>
                                            <div class="package-includes">
                                                <ul>
                                                    <?php $__currentLoopData = explode(',', $package->inclusions); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inclusion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><span><?php echo e(trim($inclusion)); ?></span></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($package->highlights): ?>
                                            <div class="others-feature">
                                                <ul>
                                                    <?php $__currentLoopData = explode(',', $package->highlights); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $highlight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e(trim($highlight)); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <h3>₹<?php echo e(number_format($package->price)); ?> <sup>Per person</sup></h3>
                                        <?php if($package->original_price): ?>
                                            <h5><del>₹<?php echo e(number_format($package->original_price)); ?></del>
                                                <span><?php echo e(round((($package->original_price - $package->price) / $package->original_price) * 100)); ?>%
                                                    OFF</span>
                                            </h5>
                                        <?php endif; ?>
                                        <p class="updated-date">Updated on: <?php echo e($package->updated_at->format('d F Y')); ?></p>
                                        <a href="javascript:void(0)" class="btn btn-primary open-enquiry-form"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal"
                                            data-package="<?php echo e($package->title); ?>">
                                            Customised & Send Enquiry
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <section id="faq" class="section-pad faq-sec">
        <div class="container">
            <div class="section-header text-center">
                <h3>Frequently Asked Questions</h3>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="accordion" id="accordionExample">
                        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="heading<?php echo e($index); ?>">
                                    <button class="accordion-button <?php echo e($index > 0 ? 'collapsed' : ''); ?>" type="button"
                                        data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($index); ?>"
                                        aria-expanded="<?php echo e($index == 0 ? 'true' : 'false'); ?>">
                                        Q: <?php echo e($faq->question); ?>

                                    </button>
                                </h2>
                                <div id="collapse<?php echo e($index); ?>"
                                    class="accordion-collapse collapse <?php echo e($index == 0 ? 'show' : ''); ?>"
                                    aria-labelledby="heading<?php echo e($index); ?>" data-bs-parent="#accordionExample">
                                    <div class="accordion-body"><?php echo $faq->answer; ?></div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="section-pad">
        <div class="container">
            <div class="section-header text-center">
                <h3>Why Choose Us</h3>
            </div>
            <div class="row">
                <?php $__currentLoopData = $whyChooseUs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-6">
                        <div class="why-us-bx">
                            <?php if($item->image): ?>
                                <img src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($item->title); ?>">
                            <?php endif; ?>
                            <h4><?php echo e($item->title); ?></h4>
                            <p><?php echo e($item->description); ?></p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <section class="section-pad">

    </section>
    <footer id="contact" class="footer">
        <div class="footer-top">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-12 text-lg-center">
                        <div class="footer-content">
                            <img src="<?php echo e(asset($footer->logo ?? 'images/flydivinetreasurekashlogo.png')); ?>" alt="logo">
                            <p><?php echo e($footer->tagline ?? 'Your Gateway to Breathtaking Adventures in the Heart of Kashmir!'); ?>

                            </p>
                        </div>
                        <div class="footer-link social-link">
                            <h4>Follow Us</h4>
                            <ul>
                                <?php if($footer->facebook_url): ?>
                                    <li><a href="<?php echo e($footer->facebook_url); ?>" target="_blank"><i
                                                class="fa-brands fa-facebook-f"></i></a></li>
                                <?php endif; ?>
                                <?php if($footer->instagram_url): ?>
                                    <li><a href="<?php echo e($footer->instagram_url); ?>" target="_blank"><i
                                                class="fa-brands fa-instagram"></i></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="gradient-hr"></div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Quick Links</h4>
                            <ul>
                                <li><a href="#">Home</a></li>
                                <li><a href="#Packages">Tour Packages</a></li>
                                <li><a href="#Destinations">Destinations</a></li>
                                <li><a href="#faq">FAQ</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Support</h4>
                            <ul>
                                <li><a href="<?php echo e(route('static.page', 'cancellation-refunds')); ?>">Cancellation &
                                        Refunds</a></li>
                                <li><a href="<?php echo e(route('static.page', 'privacy-policy')); ?>">Privacy Policy</a></li>
                                <li><a href="<?php echo e(route('static.page', 'terms-conditions')); ?>">Terms & Conditions</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Contact Info</h4>
                            <ul>
                                <?php if($footer->email): ?>
                                    <li><a href="mailto:<?php echo e($footer->email); ?>"><i class="fa-solid fa-envelope"></i>
                                            <?php echo e($footer->email); ?></a></li>
                                <?php endif; ?>
                                <?php if($footer->phone): ?>
                                    <li><a href="tel:<?php echo e($footer->phone); ?>"><i class="fa-solid fa-phone"></i>
                                            <?php echo e($footer->phone); ?></a></li>
                                <?php endif; ?>
                                <?php if($footer->address): ?>
                                    <li><a href="#"><i class="fa-solid fa-location-dot"></i> <?php echo e($footer->address); ?></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-link">
                            <h4>Gallery</h4>
                            <div class="footer-images">
                                <?php if($footer->gallery_images && is_array($footer->gallery_images)): ?>
                                    <?php $__currentLoopData = $footer->gallery_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <img src="<?php echo e(asset($image)); ?>" alt="Gallery">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <p class="text-center text-light">&copy; <?php echo e(date('Y')); ?> slipinholidays. All Rights Reserved.
                    Developed By <a href="https://elyspace.com/web-design" class="text-light">ElySpace</a></p>
            </div>
        </div>
    </footer>

    <!-- Button trigger modal -->

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-end">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="booking-form p-0">
                        <div class="package-info">
                            <div class="package-info-content">
                                <h4>Talk to Expert</h4>
                            </div>
                        </div>
                        <form action="<?php echo e(route('enquiry.store')); ?>" method="POST" id="modalForm">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="package_name" id="package_name">
                            <div class="form-group">
                                <input type="text" name="name" class="form-control" placeholder="Your Name" required
                                    pattern="[A-Za-z\s]+" title="Please enter only letters and spaces">
                            </div>
                            <div class="form-group">
                                <input type="tel" name="mobile" class="form-control"
                                    placeholder="Enter 10 digit mobile number" required pattern="[0-9]{10}"
                                    maxlength="10" minlength="10" title="Please enter exactly 10 digit mobile number"
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                            </div>
                            <div class="form-group">
                                <input type="email" name="email" class="form-control" placeholder="Email Id" required
                                    title="Please enter a valid email address with @">
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input type="number" name="persons" class="form-control"
                                            placeholder="Number Of Person" required min="1"
                                            title="Please enter at least 1 person"
                                            oninput="if(this.value < 1) this.value = 1">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input type="date" name="booking_date" class="form-control booking-date"
                                            placeholder="Booking Date" required title="Please select a future date">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <textarea name="message" class="form-control" placeholder="Message"></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary btn-main">Connect with an Expert</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <?php if($footer->whatsapp_number): ?>
        <a href="https://wa.me/<?php echo e($footer->whatsapp_number); ?>" target="_blank" class="whatsapp-icon">
            <img src="images/whatsappiconlandingpage.png" alt="whatsapp"> </a>
    <?php endif; ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="assets/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/swiper/js/swiper.min.js"></script>
    <script src="js/main.js"></script>

    <script>
        const slidesContainer = document.querySelector('.testinomials-box');
        const prevBtn = document.querySelector('.prev-btn');
        const nextBtn = document.querySelector('.next-btn');
        let currentSlide = 0;
        const totalSlides = document.querySelectorAll('.testmonial-box').length;

        function updateSlidePosition() {
            slidesContainer.style.transform = `translateX(-${currentSlide * 100}%)`;
        }

        prevBtn.addEventListener('click', () => {
            currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
            updateSlidePosition();
        });

        nextBtn.addEventListener('click', () => {
            currentSlide = (currentSlide + 1) % totalSlides;
            updateSlidePosition();
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const enquiryButtons = document.querySelectorAll(".open-enquiry-form");
            enquiryButtons.forEach(button => {
                button.addEventListener("click", function () {
                    let packageName = this.getAttribute("data-package");
                    document.getElementById("package_name").value = packageName;
                });
            });

            // Set minimum date to today for all date inputs
            const today = new Date().toISOString().split('T')[0];
            const dateInputs = document.querySelectorAll('.booking-date');
            dateInputs.forEach(input => {
                input.setAttribute('min', today);
            });
        });
    </script>


    <script>
        const hideElfsightBadge = () => {
            const badges = document.querySelectorAll('a[href*="elfsight.com/google-reviews-widget"]');
            badges.forEach(badge => {
                if (badge.textContent.includes("Free Google Reviews widget")) {
                    badge.style.display = "none";
                }
            });
        };

        // Run initially and keep checking in case it's re-added
        const observer = new MutationObserver(hideElfsightBadge);
        observer.observe(document.body, { childList: true, subtree: true });

        // Initial run
        hideElfsightBadge();
    </script>


    <script>
        document.addEventListener("DOMContentLoaded", function () {
            setTimeout(function () {
                var myModal = new bootstrap.Modal(document.getElementById('exampleModal'), {
                    backdrop: 'static', // keeps background click from closing
                    keyboard: true
                });
                myModal.show();
            }, 1000); // 3 seconds delay
        });
    </script>

</body>

</html><?php /**PATH /home/slipinho/public_html/tour.slipinholidays.com/resources/views/frontend/home.blade.php ENDPATH**/ ?>