
<?php $__env->startSection('title', 'View Enquiry'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Enquiry Details</span>
            <a href="<?php echo e(route('admin.enquiries.index')); ?>" class="btn btn-sm btn-secondary"><i
                    class="fas fa-arrow-left me-1"></i> Back</a>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <th width="150">Name:</th>
                            <td><?php echo e($enquiry->name); ?></td>
                        </tr>
                        <tr>
                            <th>Email:</th>
                            <td><a href="mailto:<?php echo e($enquiry->email); ?>"><?php echo e($enquiry->email); ?></a></td>
                        </tr>
                        <tr>
                            <th>Mobile:</th>
                            <td><a href="tel:<?php echo e($enquiry->mobile); ?>"><?php echo e($enquiry->mobile); ?></a></td>
                        </tr>
                        <tr>
                            <th>Package:</th>
                            <td><?php echo e($enquiry->package_name ?? '-'); ?></td>
                        </tr>
                        <tr>
                            <th>Persons:</th>
                            <td><?php echo e($enquiry->persons ?? '-'); ?></td>
                        </tr>
                        <tr>
                            <th>Booking Date:</th>
                            <td><?php echo e($enquiry->booking_date ? $enquiry->booking_date->format('M d, Y') : '-'); ?></td>
                        </tr>
                        <tr>
                            <th>Submitted:</th>
                            <td><?php echo e($enquiry->created_at->format('M d, Y h:i A')); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <div class="card bg-light">
                        <div class="card-header">Message</div>
                        <div class="card-body"><?php echo e($enquiry->message ?? 'No message provided'); ?></div>
                    </div>
                </div>
            </div>
            <hr>
            <form action="<?php echo e(route('admin.enquiries.destroy', $enquiry)); ?>" method="POST" class="d-inline"
                onsubmit="return confirm('Are you sure you want to delete this enquiry?')">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger"><i class="fas fa-trash me-1"></i> Delete Enquiry</button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/enquiries/show.blade.php ENDPATH**/ ?>