
<?php $__env->startSection('title', 'SEO Settings'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <i class="fas fa-search me-2"></i>Home Page SEO Settings
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('admin.seo-settings.update')); ?>" method="POST">
                <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>

                <div class="mb-3">
                    <label class="form-label">Meta Title</label>
                    <input type="text" name="meta_title" class="form-control"
                        value="<?php echo e(old('meta_title', $settings->meta_title)); ?>"
                        placeholder="e.g., Best Kashmir Tour Packages | Explore Paradise on Earth">
                    <small class="text-muted">Recommended: 50-60 characters for optimal display in search results</small>
                </div>

                <div class="mb-3">
                    <label class="form-label">Meta Description</label>
                    <textarea name="meta_description" class="form-control" rows="3"
                        placeholder="e.g., Explore Kashmir with affordable tour packages. Stay in Dal Lake houseboats, enjoy skiing in Gulmarg..."><?php echo e(old('meta_description', $settings->meta_description)); ?></textarea>
                    <small class="text-muted">Recommended: 150-160 characters for optimal display in search results</small>
                </div>

                <div class="mb-3">
                    <label class="form-label">Meta Keywords</label>
                    <textarea name="meta_keywords" class="form-control" rows="2"
                        placeholder="e.g., Kashmir tour packages, Kashmir travel guide, best places to visit in Kashmir"><?php echo e(old('meta_keywords', $settings->meta_keywords)); ?></textarea>
                    <small class="text-muted">Comma-separated keywords (Note: Most search engines no longer use
                        this)</small>
                </div>

                <div class="mb-3">
                    <label class="form-label">Meta Author</label>
                    <input type="text" name="meta_author" class="form-control"
                        value="<?php echo e(old('meta_author', $settings->meta_author)); ?>" placeholder="e.g., ElySpace">
                </div>

                <hr class="my-4">
                <h5 class="mb-3"><i class="fas fa-palette me-2"></i>Theme Settings</h5>

                <div class="mb-3">
                    <label class="form-label">Primary Color</label>
                    <div class="input-group" style="max-width: 300px;">
                        <input type="color" name="primary_color" class="form-control form-control-color"
                            value="<?php echo e(old('primary_color', $settings->primary_color ?? '#008746')); ?>"
                            title="Choose primary color">
                        <input type="text" class="form-control color-hex"
                            value="<?php echo e(old('primary_color', $settings->primary_color ?? '#008746')); ?>" placeholder="#008746"
                            readonly>
                    </div>
                    <small class="text-muted">Used for buttons, links, and main accents</small>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Package Time Badge - Background</label>
                            <div class="input-group" style="max-width: 250px;">
                                <input type="color" name="package_time_bg" class="form-control form-control-color"
                                    value="<?php echo e(old('package_time_bg', $settings->package_time_bg ?? '#008746')); ?>">
                                <input type="text" class="form-control color-hex"
                                    value="<?php echo e(old('package_time_bg', $settings->package_time_bg ?? '#008746')); ?>" readonly>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Package Time Badge - Text Color</label>
                            <div class="input-group" style="max-width: 250px;">
                                <input type="color" name="package_time_text" class="form-control form-control-color"
                                    value="<?php echo e(old('package_time_text', $settings->package_time_text ?? '#ffffff')); ?>">
                                <input type="text" class="form-control color-hex"
                                    value="<?php echo e(old('package_time_text', $settings->package_time_text ?? '#ffffff')); ?>"
                                    readonly>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Package Includes Tags - Background</label>
                            <div class="input-group" style="max-width: 250px;">
                                <input type="color" name="package_includes_bg" class="form-control form-control-color"
                                    value="<?php echo e(old('package_includes_bg', $settings->package_includes_bg ?? '#008746')); ?>">
                                <input type="text" class="form-control color-hex"
                                    value="<?php echo e(old('package_includes_bg', $settings->package_includes_bg ?? '#008746')); ?>"
                                    readonly>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Package Includes Tags - Text Color</label>
                            <div class="input-group" style="max-width: 250px;">
                                <input type="color" name="package_includes_text" class="form-control form-control-color"
                                    value="<?php echo e(old('package_includes_text', $settings->package_includes_text ?? '#ffffff')); ?>">
                                <input type="text" class="form-control color-hex"
                                    value="<?php echo e(old('package_includes_text', $settings->package_includes_text ?? '#ffffff')); ?>"
                                    readonly>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Destination Section - Background Color</label>
                    <div class="input-group" style="max-width: 300px;">
                        <input type="color" name="destination_sec_bg" class="form-control form-control-color"
                            value="<?php echo e(old('destination_sec_bg', $settings->destination_sec_bg ?? '#fff5f9')); ?>">
                        <input type="text" class="form-control color-hex"
                            value="<?php echo e(old('destination_sec_bg', $settings->destination_sec_bg ?? '#fff5f9')); ?>" readonly>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-1"></i>Update SEO Settings
                </button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        // Sync all color pickers with their adjacent hex text fields
        document.querySelectorAll('input[type="color"]').forEach(function (colorInput) {
            colorInput.addEventListener('input', function () {
                const hexInput = this.parentElement.querySelector('.color-hex');
                if (hexInput) {
                    hexInput.value = this.value;
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/slipinho/public_html/tour.slipinholidays.com/resources/views/admin/seo-settings/edit.blade.php ENDPATH**/ ?>