

<?php $__env->startSection('title', 'Banners'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Homepage Banners</span>
            <a href="<?php echo e(route('admin.banners.create')); ?>" class="btn btn-primary btn-sm">
                <i class="fas fa-plus me-1"></i> Add New
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <img src="<?php echo e(asset($banner->image)); ?>" alt=""
                                        style="width: 100px; height: 60px; object-fit: cover; border-radius: 5px;">
                                </td>
                                <td>
                                    <strong><?php echo e($banner->title); ?></strong><br>
                                    <small class="text-muted"><?php echo e($banner->subtitle); ?></small>
                                </td>
                                <td>₹<?php echo e(number_format($banner->price)); ?></td>
                                <td>
                                    <?php if($banner->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($banner->sort_order); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.banners.edit', $banner)); ?>"
                                        class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                    <form action="<?php echo e(route('admin.banners.destroy', $banner)); ?>" method="POST" class="d-inline"
                                        onsubmit="return confirm('Are you sure?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">No banners found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($banners->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/banners/index.blade.php ENDPATH**/ ?>